/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RequestURI;

@API(status=API.Status.STABLE)
public final class DefaultHttpLogFormatter
implements HttpLogFormatter {
    public String format(Precorrelation precorrelation, HttpRequest request) throws IOException {
        String correlationId = precorrelation.getId();
        String body = request.getBodyAsString();
        StringBuilder result = new StringBuilder(body.length() + 2048);
        result.append(this.direction((HttpMessage)request));
        result.append(" Request: ");
        result.append(correlationId);
        result.append('\n');
        result.append("Remote: ");
        result.append(request.getRemote());
        result.append('\n');
        result.append(request.getMethod());
        result.append(' ');
        RequestURI.reconstruct((HttpRequest)request, (StringBuilder)result);
        result.append(' ');
        result.append(request.getProtocolVersion());
        result.append('\n');
        this.writeHeaders((Map<String, List<String>>)request.getHeaders(), result);
        request.getAttributes().forEach((key, value) -> {
            result.append("Request Attribute `");
            result.append((String)key);
            result.append("`: ");
            result.append(value);
            result.append('\n');
        });
        this.writeBody(body, result);
        return result.toString();
    }

    public String format(Correlation correlation, HttpResponse response) throws IOException {
        String correlationId = correlation.getId();
        String body = response.getBodyAsString();
        StringBuilder result = new StringBuilder(body.length() + 2048);
        result.append(this.direction((HttpMessage)response));
        result.append(" Response: ");
        result.append(correlationId);
        result.append("\nDuration: ");
        result.append(correlation.getDuration().toMillis());
        result.append(" ms\n");
        result.append(response.getProtocolVersion());
        result.append(' ');
        result.append(response.getStatus());
        String reasonPhrase = response.getReasonPhrase();
        if (reasonPhrase != null) {
            result.append(' ');
            result.append(reasonPhrase);
        }
        result.append('\n');
        this.writeHeaders((Map<String, List<String>>)response.getHeaders(), result);
        response.getAttributes().forEach((key, value) -> {
            result.append("Response Attribute `");
            result.append((String)key);
            result.append("`: ");
            result.append(value);
            result.append('\n');
        });
        this.writeBody(body, result);
        return result.toString();
    }

    private String direction(HttpMessage request) {
        return request.getOrigin() == Origin.REMOTE ? "Incoming" : "Outgoing";
    }

    private void writeHeaders(Map<String, List<String>> headers, StringBuilder output) {
        if (headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            output.append(entry.getKey());
            output.append(": ");
            List<String> headerValues = entry.getValue();
            if (!headerValues.isEmpty()) {
                for (String value : entry.getValue()) {
                    output.append(value);
                    output.append(", ");
                }
                output.setLength(output.length() - 2);
            }
            output.append('\n');
        }
    }

    private void writeBody(String body, StringBuilder output) {
        if (!body.isEmpty()) {
            output.append('\n');
            output.append(body);
        } else {
            output.setLength(output.length() - 1);
        }
    }
}

