/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMessage;
import org.zalando.logbook.netty.Ignoring;
import org.zalando.logbook.netty.State;

final class Buffering
implements State {
    private final ByteBuf buffer;

    Buffering(int initialCapacity) {
        this.buffer = Unpooled.buffer((int)initialCapacity);
    }

    @Override
    public State without() {
        return new Ignoring(this);
    }

    @Override
    public State buffer(HttpMessage message, ByteBuf content) {
        int index = content.readerIndex();
        this.buffer.ensureWritable(content.readableBytes());
        content.readBytes(this.buffer, content.readableBytes());
        content.readerIndex(index);
        return this;
    }

    @Override
    public byte[] getBody() {
        int length = this.buffer.readableBytes();
        if (length == this.buffer.capacity()) {
            return this.buffer.array();
        }
        byte[] target = new byte[length];
        System.arraycopy(this.buffer.array(), 0, target, 0, length);
        return target;
    }
}

