/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.openfeign;

import feign.Response;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.openfeign.HeaderUtils;

final class RemoteResponse
implements HttpResponse {
    private final int status;
    private final HttpHeaders headers;
    private final byte[] body;
    private final Charset charset;
    private boolean withBody = false;

    public static RemoteResponse create(Response response, byte[] body) {
        return new RemoteResponse(response.status(), HeaderUtils.toLogbookHeaders(response.headers()), body, response.charset());
    }

    public int getStatus() {
        return this.status;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable((List)this.headers.get((Object)"Content-Type")).flatMap(ct -> ct.stream().findFirst()).orElse(null);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HttpResponse withBody() {
        this.withBody = true;
        return this;
    }

    public RemoteResponse withoutBody() {
        this.withBody = false;
        return this;
    }

    public byte[] getBody() {
        return this.withBody && this.body != null ? this.body : new byte[]{};
    }

    @Generated
    public RemoteResponse(int status, HttpHeaders headers, byte[] body, Charset charset) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.charset = charset;
    }
}

