/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.po;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fedorahosted.tennera.jgettext.HeaderFields;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.MessageStreamParser;
import org.xml.sax.InputSource;
import org.zanata.common.ContentState;
import org.zanata.common.ContentType;
import org.zanata.common.LocaleId;
import org.zanata.common.util.ContentStateUtil;
import org.zanata.rest.dto.ExtensionValue;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.extensions.gettext.HeaderEntry;
import org.zanata.rest.dto.extensions.gettext.PoHeader;
import org.zanata.rest.dto.extensions.gettext.PoTargetHeader;
import org.zanata.rest.dto.extensions.gettext.PotEntryHeader;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.HashUtil;
import org.zanata.util.ShortString;

public class PoReader2 {
    public static final ContentType PO_CONTENT_TYPE = new ContentType("application/x-gettext");
    public static final ImmutableSet<String> POT_HEADER_FIELDS = ImmutableSet.of((Object)"Project-Id-Version", (Object)"Report-Msgid-Bugs-To", (Object)"POT-Creation-Date", (Object)"MIME-Version", (Object)"Content-Type", (Object)"Content-Transfer-Encoding", (Object[])new String[0]);
    public static final ImmutableSet<String> PO_HEADER_FIELDS = ImmutableSet.of((Object)"PO-Revision-Date", (Object)"Last-Translator", (Object)"Language-Team", (Object)"Language", (Object)"Plural-Forms", (Object)"X-Generator", (Object[])new String[0]);
    private boolean mapIdFromMsgctxt;

    public PoReader2(boolean mapIdFromMsgctxt) {
        this.mapIdFromMsgctxt = mapIdFromMsgctxt;
    }

    public PoReader2() {
        this(false);
    }

    public TranslationsResource extractTarget(InputSource inputSource) {
        TranslationsResource document = new TranslationsResource();
        MessageStreamParser messageParser = PoReader2.createParser(inputSource);
        boolean headerFound = false;
        while (messageParser.hasNext()) {
            Message message = messageParser.next();
            if (message.isHeader()) {
                if (headerFound) {
                    throw new IllegalStateException("found a second header!");
                }
                headerFound = true;
                PoTargetHeader poHeader = new PoTargetHeader();
                PoReader2.extractPoHeader(message, poHeader);
                document.getExtensions(true).add((ExtensionValue)poHeader);
                continue;
            }
            if (message.isObsolete()) continue;
            String id = this.createId(message);
            TextFlowTarget tfTarget = new TextFlowTarget();
            tfTarget.setResId(id);
            List<String> sourceContents = this.getSourceContents(message);
            tfTarget.setSourceHash(HashUtil.sourceHash(sourceContents));
            tfTarget.setDescription(ShortString.shorten((String)message.getMsgid()));
            tfTarget.setContents(PoReader2.getContents(message));
            tfTarget.setState(PoReader2.getContentState(message));
            tfTarget.getExtensions(true).add((ExtensionValue)new SimpleComment(StringUtils.join((Collection)message.getComments(), (String)"\n")));
            document.getTextFlowTargets().add(tfTarget);
        }
        return document;
    }

    private static void checkContentType(HeaderFields hf) {
        String contentType = hf.getValue("Content-Type");
        if (contentType == null) {
            return;
        }
        String ct = contentType.toLowerCase();
        if (!ct.contains("charset=")) {
            return;
        }
        if (ct.contains("charset=charset") || ct.contains("charset=ascii") || ct.contains("charset=utf-8") || ct.contains("charset=utf8")) {
            return;
        }
        throw new RuntimeException("unsupported charset in Content-Type: " + contentType);
    }

    private static void extractPotHeader(Message message, PoHeader potHeader) {
        potHeader.setComment(StringUtils.join((Collection)message.getComments(), (String)"\n"));
        HeaderFields hf = HeaderFields.wrap((Message)message);
        PoReader2.checkContentType(hf);
        for (String key : hf.getKeys()) {
            String val = hf.getValue(key);
            if (!POT_HEADER_FIELDS.contains((Object)key)) continue;
            potHeader.getEntries().add(new HeaderEntry(key, val));
        }
    }

    private static void extractPoHeader(Message message, PoTargetHeader poHeader) {
        poHeader.setComment(StringUtils.join((Collection)message.getComments(), (String)"\n"));
        HeaderFields hf = HeaderFields.wrap((Message)message);
        PoReader2.checkContentType(hf);
        for (String key : hf.getKeys()) {
            String val = hf.getValue(key);
            if (PO_HEADER_FIELDS.contains((Object)key)) {
                poHeader.getEntries().add(new HeaderEntry(key, val));
                continue;
            }
            if (POT_HEADER_FIELDS.contains((Object)key)) continue;
            poHeader.getEntries().add(new HeaderEntry(key, val));
        }
    }

    public Resource extractTemplate(InputSource inputSource, LocaleId sourceLocaleId, String docName) {
        Resource document = new Resource(docName);
        MessageStreamParser messageParser = PoReader2.createParser(inputSource);
        document.setLang(sourceLocaleId);
        document.setContentType(PO_CONTENT_TYPE);
        List resources = document.getTextFlows();
        boolean headerFound = false;
        while (messageParser.hasNext()) {
            Message message = messageParser.next();
            if (message.isHeader()) {
                if (headerFound) {
                    throw new IllegalStateException("found a second header!");
                }
                headerFound = true;
                PoHeader potHeader = new PoHeader();
                PoReader2.extractPotHeader(message, potHeader);
                document.getExtensions(true).add((ExtensionValue)potHeader);
                continue;
            }
            if (message.isObsolete()) continue;
            String id = this.createId(message);
            TextFlow tf = new TextFlow(id, sourceLocaleId);
            tf.setPlural(message.isPlural());
            if (message.isPlural()) {
                tf.setContents(new String[]{message.getMsgid(), message.getMsgidPlural()});
            } else {
                tf.setContents(new String[]{message.getMsgid()});
            }
            resources.add(tf);
            tf.getExtensions(true).add((ExtensionValue)PoReader2.createPotEntryHeader(message));
            tf.getExtensions().add((ExtensionValue)PoReader2.createSimpleComment(message));
        }
        return document;
    }

    private static PotEntryHeader createPotEntryHeader(Message message) {
        PotEntryHeader data = new PotEntryHeader();
        if (message.getMsgctxt() != null) {
            data.setContext(message.getMsgctxt());
        }
        data.getFlags().addAll(message.getFormats());
        data.getReferences().addAll(message.getSourceReferences());
        return data;
    }

    private static SimpleComment createSimpleComment(Message message) {
        String comment = StringUtils.join((Collection)message.getExtractedComments(), (String)"\n");
        SimpleComment result = new SimpleComment(comment);
        return result;
    }

    static MessageStreamParser createParser(InputSource inputSource) {
        MessageStreamParser messageParser;
        if (inputSource.getCharacterStream() != null) {
            messageParser = new MessageStreamParser(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            messageParser = inputSource.getEncoding() != null ? new MessageStreamParser(inputSource.getByteStream(), Charset.forName(inputSource.getEncoding())) : new MessageStreamParser(inputSource.getByteStream(), Charset.forName("UTF-8"));
        } else if (inputSource.getSystemId() != null) {
            try {
                URL url = new URL(inputSource.getSystemId());
                if (inputSource.getEncoding() != null) {
                    messageParser = new MessageStreamParser(url.openStream(), Charset.forName(inputSource.getEncoding()));
                }
                messageParser = new MessageStreamParser(url.openStream(), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to get input from url in inputSource", e);
            }
        } else {
            throw new RuntimeException("not a valid inputSource");
        }
        return messageParser;
    }

    private List<String> getSourceContents(Message message) {
        List<String> sourceContents = message.isPlural() ? Arrays.asList(message.getMsgid(), message.getMsgidPlural()) : Arrays.asList(message.getMsgid());
        return sourceContents;
    }

    private static List<String> getContents(Message message) {
        if (message.isPlural()) {
            List plurals = message.getMsgstrPlural();
            if (plurals.isEmpty()) {
                return Arrays.asList("");
            }
            return plurals;
        }
        return Arrays.asList(message.getMsgstr());
    }

    static ContentState getContentState(Message message) {
        ContentState requestedState = message.isFuzzy() ? ContentState.NeedReview : ContentState.Translated;
        List<String> contents = PoReader2.getContents(message);
        return ContentStateUtil.determineState((ContentState)requestedState, contents);
    }

    private String createId(Message message) {
        return PoReader2.createId(message, this.mapIdFromMsgctxt);
    }

    static String createId(Message message, boolean mapIdFromMsgctxt) {
        if (mapIdFromMsgctxt) {
            String zanataId = message.getMsgctxt();
            if (zanataId == null || zanataId.isEmpty()) {
                throw new RuntimeException("Tried to map id from msgctxt but msgctxt was " + zanataId + " for text flow with source: " + message.getMsgstr());
            }
            message.setMsgctxt(null);
            return zanataId;
        }
        String sep = "\u0000";
        String hashBase = message.getMsgctxt() == null ? message.getMsgid() : message.getMsgctxt() + sep + message.getMsgid();
        return HashUtil.generateHash((String)hashBase);
    }
}

