/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.filter.ClientFilter;

class CacheResponseFilter
extends ClientFilter {
    private Optional<ClientResponse> cachedClientResponse = Optional.absent();

    CacheResponseFilter() {
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(cr);
        response.bufferEntity();
        this.cachedClientResponse = Optional.of((Object)response);
        return response;
    }

    public <T> T getEntity(Class<T> type) {
        this.checkState();
        return (T)((ClientResponse)this.cachedClientResponse.get()).getEntity(type);
    }

    public <T> T getEntity(GenericType<T> genericType) {
        this.checkState();
        return (T)((ClientResponse)this.cachedClientResponse.get()).getEntity(genericType);
    }

    private void checkState() {
        Preconditions.checkState((boolean)this.cachedClientResponse.isPresent(), (Object)"No cached ClientResponse. Did you forget to add this filter?");
    }
}

