/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidContentTypeFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(InvalidContentTypeFilter.class);
    private static final String ERROR_MSG = "Received invalid content type from the server. Most likely you're hitting an error page or being redirected. Please check the server URL is correct (in zanata.ini and in zanata.xml) and make sure you use the correct address.";
    private static final Pattern VALID_TYPES_REGEX = Pattern.compile("application/.*");

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        ClientHandler ch = this.getNext();
        ClientResponse resp = ch.handle(clientRequest);
        if (resp.getClientResponseStatus().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) && !InvalidContentTypeFilter.isContentTypeCompatible(resp.getType())) {
            log.error(ERROR_MSG);
            String title = this.findPageTitle(resp);
            String snippet = String.format("Wrong content type received: [%s]. Content page title: [%s]", resp.getType(), title);
            log.error(snippet);
            throw new IllegalStateException(snippet);
        }
        return resp;
    }

    @VisibleForTesting
    protected static boolean isContentTypeCompatible(MediaType responseContentType) {
        if (responseContentType == null || responseContentType.isWildcardType() || responseContentType.isWildcardSubtype()) {
            return true;
        }
        if (MediaType.TEXT_PLAIN_TYPE.isCompatible(responseContentType)) {
            return true;
        }
        Matcher matcher = VALID_TYPES_REGEX.matcher(responseContentType.toString());
        return matcher.matches();
    }

    private String findPageTitle(ClientResponse resp) {
        String body = ((String)resp.getEntity(String.class)).replaceAll("\\n", " ");
        Pattern pattern = Pattern.compile(".*<title>(.*)</title>.*");
        Matcher matcher = pattern.matcher(body);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }
}

