/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Serializables {
    public static final Logger logio = LoggerFactory.getLogger((String)"org.zkoss.io.serializable");

    private Serializables() {
    }

    public static <K, V> void smartWrite(ObjectOutputStream s, Map<K, V> map) throws IOException {
        if (map != null) {
            boolean debug = logio.isDebugEnabled();
            for (Map.Entry<K, V> me : map.entrySet()) {
                K nm = me.getKey();
                V val = me.getValue();
                if ((nm instanceof Serializable || nm instanceof Externalizable) && (val == null || val instanceof Serializable || val instanceof Externalizable)) {
                    try {
                        s.writeObject(nm);
                        s.writeObject(val);
                        continue;
                    }
                    catch (NotSerializableException ex) {
                        logio.error("Unable to serialize entry: " + nm + '=' + val);
                        throw ex;
                    }
                }
                if (nm == null || !debug) continue;
                logio.debug("Skip not-serializable entry: " + nm + '=' + val);
            }
        }
        s.writeObject(null);
    }

    public static <K, V> Map<K, V> smartRead(ObjectInputStream s, Map<K, V> map) throws IOException, ClassNotFoundException {
        Object nm;
        while ((nm = s.readObject()) != null) {
            if (map == null) {
                map = new HashMap();
            }
            map.put(nm, s.readObject());
        }
        return map;
    }

    public static <T> void smartWrite(ObjectOutputStream s, Collection<T> col) throws IOException {
        if (col != null) {
            boolean debug = logio.isDebugEnabled();
            for (T val : col) {
                if (val instanceof Serializable || val instanceof Externalizable) {
                    try {
                        s.writeObject(val);
                        continue;
                    }
                    catch (NotSerializableException ex) {
                        logio.error("Unable to serialize item: " + val);
                        throw ex;
                    }
                }
                if (val == null || !debug) continue;
                logio.debug("Skip not-serializable item: " + val);
            }
        }
        s.writeObject(null);
    }

    public static <T> Collection<T> smartRead(ObjectInputStream s, Collection<T> col) throws IOException, ClassNotFoundException {
        Object val;
        while ((val = s.readObject()) != null) {
            if (col == null) {
                col = new LinkedList<T>();
            }
            col.add(val);
        }
        return col;
    }

    public static <T> List<T> smartRead(ObjectInputStream s, List<T> col) throws IOException, ClassNotFoundException {
        Object val;
        while ((val = s.readObject()) != null) {
            if (col == null) {
                col = new LinkedList<T>();
            }
            col.add(val);
        }
        return col;
    }

    public static <T> void smartWrite(ObjectOutputStream s, T[] ary) throws IOException {
        if (ary != null) {
            boolean debug = logio.isDebugEnabled();
            for (int j = 0; j < ary.length; ++j) {
                T val = ary[j];
                if (val instanceof Serializable || val instanceof Externalizable) {
                    try {
                        s.writeObject(val);
                        continue;
                    }
                    catch (NotSerializableException ex) {
                        logio.error("Unable to serialize item: " + val);
                        throw ex;
                    }
                }
                if (val == null || !debug) continue;
                logio.debug("Skip not-serializable item: " + val);
            }
        }
        s.writeObject(null);
    }

    public static void smartWrite(ObjectOutputStream s, Object val) throws IOException {
        boolean bser = val instanceof Serializable || val instanceof Externalizable;
        s.writeObject(bser ? val : null);
        if (!bser && val != null && logio.isDebugEnabled()) {
            logio.debug("Skip not-serializable object: " + val);
        }
    }
}

