/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.BindChildRenderer;
import org.zkoss.bind.impl.ChildrenBindingImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.LoadChildrenBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.LoadInfo;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadChildrenBindingImpl
extends ChildrenBindingImpl
implements LoadChildrenBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private final Set<String> _doneDependsOn = new HashSet<String>(4);

    public LoadChildrenBindingImpl(Binder binder, Component comp, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        super(binder, comp, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
    }

    @Override
    public void load(BindContext ctx) {
        Component comp = this.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        BindingExecutionInfoCollector collector = ((BinderCtrl)((Object)this.getBinder())).getBindingExecutionInfoCollector();
        Object value = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        boolean activating = ((BinderCtrl)((Object)this.getBinder())).isActivating();
        Converter conv = this.getConverter();
        if (conv != null) {
            if (activating) {
                return;
            }
            Object old = value;
            if ((value = conv.coerceToUi(old, comp, ctx)) == Converter.IGNORED_VALUE) {
                if (collector != null) {
                    collector.addInfo(new LoadInfo("children-load", comp, this.getConditionString(ctx), this.getPropertyString(), null, old, this.getArgs(), "*Converter.IGNORED_VALUE"));
                }
                return;
            }
        }
        if (activating) {
            return;
        }
        comp.getChildren().clear();
        BindELContext.removeModel(comp);
        if (value != null) {
            List data = null;
            if (!(value instanceof List)) {
                throw new UiException(value + " is not a List, is " + value.getClass());
            }
            data = (List)value;
            BindChildRenderer renderer = new BindChildRenderer();
            BindELContext.addModel(comp, data);
            int size = data.size();
            for (int i = 0; i < size; ++i) {
                renderer.render(comp, data.get(i), i, size);
            }
        }
        if (collector != null) {
            collector.addInfo(new LoadInfo("children-load", comp, this.getConditionString(ctx), this.getPropertyString(), "", value, this.getArgs(), null));
        }
    }

    private String getConditionString(BindContext ctx) {
        StringBuilder condition = new StringBuilder();
        if (this.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(this.getCommandName()).append("'");
        } else if (this.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(this.getCommandName()).append("'");
        } else {
            condition.append(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName());
        }
        return condition.length() == 0 ? null : condition.toString();
    }

    private Method getConverterMethod(Class<? extends Converter> cls) {
        try {
            return cls.getMethod("coerceToUi", Object.class, Component.class, BindContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public void addDependsOnTrackings(List<String> srcpath, String basepath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn.add(src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(this, srcpath, basepath, prop);
        }
    }
}

