/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.tracker.impl;

import java.util.Collection;
import org.zkoss.bind.AnnotateBinder;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AnnotateBinderHelper;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.UiLifeCycle;

public class BindUiLifeCycle
implements UiLifeCycle {
    static final Log log = Log.lookup(BindUiLifeCycle.class);
    private static Extension _ext;

    public void afterComponentAttached(Component comp, Page page) {
        Binder parentBinder;
        Binder selfBinder;
        if (comp.getDesktop() != null && (selfBinder = BinderUtil.getBinder(comp)) == null && (parentBinder = BinderUtil.getBinder(comp, true)) != null && parentBinder instanceof BinderImpl) {
            comp.addEventListener(10000, "onBindInit", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    Component comp = event.getTarget();
                    comp.removeEventListener("onBindInit", (EventListener)this);
                    if (comp.getPage() == null) {
                        return;
                    }
                    Binder innerBinder = BinderUtil.getBinder(comp);
                    if (innerBinder != null) {
                        return;
                    }
                    Binder binder = BinderUtil.getBinder(comp, true);
                    if (binder == null) {
                        return;
                    }
                    if (BindUiLifeCycle.getExtension().isLifeCycleHandling(comp)) {
                        return;
                    }
                    if (binder instanceof AnnotateBinder) {
                        new AnnotateBinderHelper(binder).initComponentBindings(comp);
                    }
                    BindUiLifeCycle.getExtension().markLifeCycleHandling(comp);
                    binder.loadComponent(comp, true);
                    if (comp.getAttribute("$VAR$") != null) {
                        BinderUtil.markHandling(comp, binder);
                    }
                }
            });
            Events.postEvent((Event)new Event("onBindInit", comp));
        }
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        comp.addEventListener(10000, "onBindClean", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Component comp = event.getTarget();
                comp.removeEventListener("onBindClean", (EventListener)this);
                BindUiLifeCycle.this.removeBindings(comp);
            }
        });
        Events.postEvent((Event)new Event("onBindClean", comp));
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
    }

    public void afterPageAttached(Page page, Desktop desktop) {
    }

    public void afterPageDetached(Page page, Desktop prevdesktop) {
        Collection comps = page.getRoots();
        for (Component comp : comps) {
            this.removeBindings(comp);
        }
    }

    private void removeBindings(Component comp) {
        this.removeBindings0(comp);
        for (Component kid : comp.getChildren()) {
            if (kid == null) continue;
            this.removeBindings(kid);
        }
    }

    private void removeBindings0(Component comp) {
        Binder binder;
        Object installed = comp.removeAttribute("$RENDERER_INSTALLED$");
        if (installed != null) {
            BindELContext.removeModel(comp);
        }
        if ((binder = BinderUtil.getBinder(comp)) != null) {
            binder.removeBindings(comp);
        }
        BindUiLifeCycle.getExtension().removeLifeCycleHandling(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Extension getExtension() {
        if (_ext != null) return _ext;
        Class<BindUiLifeCycle> clazz = BindUiLifeCycle.class;
        synchronized (BindUiLifeCycle.class) {
            if (_ext != null) return _ext;
            String clsnm = Library.getProperty((String)"org.zkoss.bind.tracker.impl.extension");
            if (clsnm != null) {
                try {
                    _ext = (Extension)Classes.newInstanceByThread((String)clsnm);
                }
                catch (Throwable ex) {
                    log.realCauseBriefly("Unable to instantiate " + clsnm, ex);
                }
            }
            if (_ext != null) return _ext;
            _ext = new DefaultExtension();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _ext;
        }
    }

    public static void markLifeCycleHandling(Component comp) {
        BindUiLifeCycle.getExtension().markLifeCycleHandling(comp);
    }

    private static class DefaultExtension
    implements Extension {
        private DefaultExtension() {
        }

        public void markLifeCycleHandling(Component comp) {
        }

        public boolean isLifeCycleHandling(Component comp) {
            return false;
        }

        public void removeLifeCycleHandling(Component comp) {
        }
    }

    public static interface Extension {
        public void markLifeCycleHandling(Component var1);

        public boolean isLifeCycleHandling(Component var1);

        public void removeLifeCycleHandling(Component var1);
    }
}

