/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindComposer;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormExt;
import org.zkoss.bind.GlobalCommandEvent;
import org.zkoss.bind.Phase;
import org.zkoss.bind.PhaseListener;
import org.zkoss.bind.Property;
import org.zkoss.bind.PropertyChangeEvent;
import org.zkoss.bind.SimpleForm;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.DefaultCommand;
import org.zkoss.bind.annotation.DefaultGlobalCommand;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.impl.AbstractAnnotatedMethodInvoker;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXImpl;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.ChildrenBindingHandler;
import org.zkoss.bind.impl.CommandBindingImpl;
import org.zkoss.bind.impl.FormBindingHandler;
import org.zkoss.bind.impl.ImplicitObjectContributor;
import org.zkoss.bind.impl.ImplicitObjectContributorImpl;
import org.zkoss.bind.impl.InitChildrenBindingImpl;
import org.zkoss.bind.impl.InitFormBindingImpl;
import org.zkoss.bind.impl.InitPropertyBindingImpl;
import org.zkoss.bind.impl.LoadChildrenBindingImpl;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.LoadPropertyBindingImpl;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.bind.impl.PropertyBindingHandler;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.impl.ReferenceBindingHandler;
import org.zkoss.bind.impl.ReferenceBindingImpl;
import org.zkoss.bind.impl.SaveFormBindingImpl;
import org.zkoss.bind.impl.SavePropertyBindingImpl;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.impl.SystemValidators;
import org.zkoss.bind.impl.TemplateRendererCtrl;
import org.zkoss.bind.impl.TemplateResolverImpl;
import org.zkoss.bind.impl.ValidationHelper;
import org.zkoss.bind.impl.WrongValuePropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.CommandBinding;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.InitChildrenBinding;
import org.zkoss.bind.sys.InitFormBinding;
import org.zkoss.bind.sys.InitPropertyBinding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.LoadChildrenBinding;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.DebuggerFactory;
import org.zkoss.bind.sys.debugger.impl.info.AddBindingInfo;
import org.zkoss.bind.sys.debugger.impl.info.AddCommandBindingInfo;
import org.zkoss.bind.sys.debugger.impl.info.CommandInfo;
import org.zkoss.bind.sys.debugger.impl.info.EventInfo;
import org.zkoss.bind.sys.debugger.impl.info.NotifyChangeInfo;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.tracker.impl.TrackerImpl;
import org.zkoss.bind.xel.BindXelFactory;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.CacheMap;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ExecutionInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderImpl
implements Binder,
BinderCtrl,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private static final Logger _log = LoggerFactory.getLogger(BinderImpl.class);
    private static final Map<String, Object> RENDERERS = new HashMap<String, Object>();
    public static final String BINDING = "$BINDING$";
    public static final String BINDER = "$BINDER$";
    public static final String BINDCTX = "$BINDCTX$";
    public static final String VAR = "$VAR$";
    public static final String VM = "$VM$";
    public static final String NOTIFYS = "$NOTIFYS$";
    public static final String VALIDATES = "$VALIDATES$";
    public static final String SRCPATH = "$SRCPATH$";
    public static final String DEPENDS_ON_COMP = "$DEPENDS_ON_COMP";
    public static final String RENDERER_INSTALLED = "$RENDERER_INSTALLED$";
    public static final String LOAD_FORM_EXPRESSION = "$LOAD_FORM_EXPR$";
    public static final String LOAD_FORM_COMPONENT = "$LOAD_FORM_COMP$";
    public static final String IGNORE_TRACKER = "$IGNORE_TRACKER$";
    public static final String IGNORE_REF_VALUE = "$IGNORE_REF_VALUE$";
    public static final String SAVE_BASE = "$SAVE_BASE$";
    public static final String ON_BIND_INIT = "onBindInit";
    public static final String ON_BIND_CLEAN = "onBindClean";
    public static final String MODEL = "$MODEL$";
    private static final String ON_POST_COMMAND = "onPostCommand";
    private static final String ON_VMSGS_CHANGED = "onVMsgsChanged";
    private static final String FORM_ID = "$FORM_ID$";
    private static final String CHILDREN_ATTR = "$CHILDREN$";
    private static final String ACTIVATOR = "$ACTIVATOR$";
    private static final int COMMAND_SUCCESS = 0;
    private static final int COMMAND_FAIL_VALIDATE = 1;
    private static final Map<Class<?>, List<Method>> _initMethodCache = new CacheMap(600, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _commandMethodCache = new CacheMap(200, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _globalCommandMethodCache = new CacheMap(200, 1800000);
    private static final CachedItem<Method> NULL_METHOD = new CachedItem<Object>(null);
    private static final String COMMAND_METHOD_MAP_INIT = "$INIT_FLAG$";
    private static final String COMMAND_METHOD_DEFAULT = "$DEFAULT_FLAG$";
    private static final CommandMethodInfoProvider _commandMethodInfoProvider = new CommandMethodInfoProvider(){

        public String getAnnotationName() {
            return Command.class.getSimpleName();
        }

        public String getDefaultAnnotationName() {
            return DefaultCommand.class.getSimpleName();
        }

        public String[] getCommandName(Method method) {
            Command cmd = method.getAnnotation(Command.class);
            return cmd == null ? null : cmd.value();
        }

        public boolean isDefaultMethod(Method method) {
            return method.getAnnotation(DefaultCommand.class) != null;
        }
    };
    private static final CommandMethodInfoProvider _globalCommandMethodInfoProvider = new CommandMethodInfoProvider(){

        public String getAnnotationName() {
            return GlobalCommand.class.getSimpleName();
        }

        public String getDefaultAnnotationName() {
            return DefaultGlobalCommand.class.getSimpleName();
        }

        public String[] getCommandName(Method method) {
            GlobalCommand cmd = method.getAnnotation(GlobalCommand.class);
            return cmd == null ? null : cmd.value();
        }

        public boolean isDefaultMethod(Method method) {
            return method.getAnnotation(DefaultGlobalCommand.class) != null;
        }
    };
    private Component _rootComp;
    private BindEvaluatorX _eval;
    private PhaseListener _phaseListener;
    private boolean _phaseListenerSet = false;
    private static PhaseListener _sharedPhaseListener;
    private static boolean _sharedPhaseListenerSet;
    private Tracker _tracker;
    private final Component _dummyTarget = new AbstractComponent();
    private final Map<Component, Map<String, List<Binding>>> _bindings = new HashMap<Component, Map<String, List<Binding>>>();
    private final FormBindingHandler _formBindingHandler = new FormBindingHandler();
    private final PropertyBindingHandler _propertyBindingHandler = new PropertyBindingHandler();
    private final ChildrenBindingHandler _childrenBindingHandler = new ChildrenBindingHandler();
    private final ReferenceBindingHandler _refBindingHandler;
    private Map<Component, Set<SaveBinding>> _assocFormSaveBindings;
    private Map<Component, Map<SaveBinding, Set<SaveBinding>>> _reversedAssocFormSaveBindings;
    private final Map<BindingKey, CommandEventListener> _listenerMap;
    private final String _quename;
    private final String _quescope;
    private final QueueListener _queueListener;
    private ValidationMessages _validationMessages;
    private Set<BindingKey> _hasValidators;
    private final Map<Component, Map<String, TemplateResolver>> _templateResolvers;
    private boolean _hasGetConverterMethod = true;
    private boolean _hasGetValidatorMethod = true;
    private boolean _init = false;
    private boolean _activating = false;
    private transient DeferredActivator _deferredActivator;
    private final ImplicitObjectContributor _implicitContributor;
    private static final String REF_HANDLER_CLASS_PROP = "org.zkoss.bind.ReferenceBindingHandler.class";

    public BinderImpl() {
        this(null, null);
    }

    public BinderImpl(String qname, String qscope) {
        this._formBindingHandler.setBinder(this);
        this._propertyBindingHandler.setBinder(this);
        this._childrenBindingHandler.setBinder(this);
        this._refBindingHandler = MiscUtil.newInstanceFromProperty(REF_HANDLER_CLASS_PROP, null, ReferenceBindingHandler.class);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.setBinder(this);
        }
        this._implicitContributor = new ImplicitObjectContributorImpl();
        this._assocFormSaveBindings = new HashMap<Component, Set<SaveBinding>>();
        this._reversedAssocFormSaveBindings = new HashMap<Component, Map<SaveBinding, Set<SaveBinding>>>();
        this._hasValidators = new HashSet<BindingKey>();
        this._templateResolvers = new HashMap<Component, Map<String, TemplateResolver>>();
        this._listenerMap = new HashMap<BindingKey, CommandEventListener>();
        this._quename = qname != null && !Strings.isEmpty((String)qname) ? qname : "$ZKBIND_DEFQUE$";
        this._quescope = qscope != null && !Strings.isBlank((String)qscope) ? qscope : "desktop";
        this._queueListener = new QueueListener();
    }

    protected void checkInit() {
        if (!this._init) {
            throw new UiException("binder is not initialized yet");
        }
    }

    @Override
    public void init(Component comp, Object viewModel) {
        this.init(comp, viewModel, null);
    }

    @Override
    public void init(Component comp, Object viewModel, Map<String, Object> initArgs) {
        if (this._init) {
            throw new UiException("binder is already initialized");
        }
        this._init = true;
        this._rootComp = comp;
        this.setViewModel(viewModel);
        this._dummyTarget.addEventListener(ON_POST_COMMAND, (EventListener)new PostCommandListener());
        this._dummyTarget.addEventListener(ON_VMSGS_CHANGED, (EventListener)new VMsgsChangedListener());
        this.subscribeQueue(this._quename, this._quescope, this._queueListener);
        if (viewModel instanceof Composer && !(viewModel instanceof BindComposer)) {
            _log.warn("you are using a composer [%s] as a view model", viewModel);
        }
        new AbstractAnnotatedMethodInvoker<Init>(Init.class, _initMethodCache){

            @Override
            protected boolean shouldLookupSuperclass(Init annotation) {
                return annotation.superclass();
            }
        }.invokeMethod(this, initArgs);
        this._rootComp.setAttribute(ACTIVATOR, (Object)new Activator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPropertyChange(Object base, String prop) {
        if (_log.isDebugEnabled()) {
            _log.debug("doPropertyChange:base=[%s],prop=[%s]", base, (Object)prop);
        }
        if (base instanceof ReferenceBinding && ((ReferenceBinding)base).getBinder() == this) {
            return;
        }
        Tracker tracker = this.getTracker();
        Set<LoadBinding> bindings = tracker.getLoadBindings(base, prop);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        try {
            if (collector != null) {
                collector.pushStack("NOTIFY_CHANGE");
                collector.addInfo(new NotifyChangeInfo(this._rootComp, base, prop, "Size=" + bindings.size()));
            }
            this.doPropertyChange0(base, prop, bindings);
        }
        finally {
            if (collector != null) {
                collector.popStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPropertyChange0(Object base, String prop, Set<LoadBinding> bindings) {
        for (LoadBinding binding : bindings) {
            Component comp = binding.getComponent();
            if (comp == null || comp.getPage() == null) continue;
            BindContext ctx = BindContextUtil.newBindContext(this, binding, false, null, comp, null);
            if (binding instanceof PropertyBinding) {
                BindContextUtil.setConverterArgs(this, comp, ctx, (PropertyBinding)((Object)binding));
            }
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("doPropertyChange:binding.load(),binding=[%s],context=[%s]", (Object)binding, (Object)ctx);
                }
                this.doPrePhase(Phase.LOAD_BINDING, ctx);
                binding.load(ctx);
            }
            finally {
                this.doPostPhase(Phase.LOAD_BINDING, ctx);
            }
            if (binding instanceof ReferenceBinding && binding != base) {
                this.notifyChange(binding, ".");
            }
            if (this._validationMessages == null) continue;
            String attr = null;
            if (binding instanceof PropertyBinding) {
                attr = ((PropertyBinding)((Object)binding)).getFieldName();
            } else if (binding instanceof FormBinding) {
                attr = ((FormBinding)((Object)binding)).getFormId();
            }
            if (attr == null || !this.hasValidator(comp, attr)) continue;
            this._validationMessages.clearMessages(comp, attr);
        }
    }

    @Override
    public void setViewModel(Object vm) {
        this.checkInit();
        this._rootComp.setAttribute(VM, vm);
        this._hasGetConverterMethod = true;
        this._hasGetValidatorMethod = true;
    }

    @Override
    public Object getViewModel() {
        this.checkInit();
        return this._rootComp.getAttribute(VM);
    }

    @Override
    public Converter getConverter(String name) {
        this.checkInit();
        Converter converter = null;
        if (this._hasGetConverterMethod) {
            Object vm = this.getViewModel();
            Class<?> clz = vm.getClass();
            Method m = null;
            Object result = null;
            try {
                m = clz.getMethod("getConverter", String.class);
            }
            catch (SecurityException x) {
                this._hasGetConverterMethod = false;
            }
            catch (NoSuchMethodException e) {
                this._hasGetConverterMethod = false;
            }
            if (m != null) {
                try {
                    result = m.invoke(vm, name);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    this._hasGetConverterMethod = false;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (result != null && !(result instanceof Converter)) {
                    this._hasGetConverterMethod = false;
                } else {
                    converter = (Converter)result;
                }
            }
        }
        if (converter == null) {
            converter = SystemConverters.get(name);
        }
        if (converter == null) {
            throw new UiException("Cannot find converter:" + name);
        }
        return converter;
    }

    @Override
    public Validator getValidator(String name) {
        this.checkInit();
        Validator validator = null;
        if (this._hasGetValidatorMethod) {
            Object vm = this.getViewModel();
            Class<?> clz = vm.getClass();
            Method m = null;
            Object result = null;
            try {
                m = clz.getMethod("getValidator", String.class);
            }
            catch (SecurityException x) {
                this._hasGetValidatorMethod = false;
            }
            catch (NoSuchMethodException e) {
                this._hasGetValidatorMethod = false;
            }
            if (m != null) {
                try {
                    result = m.invoke(vm, name);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    this._hasGetValidatorMethod = false;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (result != null && !(result instanceof Validator)) {
                    this._hasGetValidatorMethod = false;
                } else {
                    validator = (Validator)result;
                }
            }
        }
        if (validator == null) {
            validator = SystemValidators.get(name);
        }
        if (validator == null) {
            throw new UiException("Cannot find validator:" + name);
        }
        return validator;
    }

    protected Object getRenderer(String name) {
        Object renderer = RENDERERS.get(name);
        if (renderer == null && name.indexOf(46) > 0) {
            try {
                renderer = Classes.newInstanceByThread((String)name);
                RENDERERS.put(name, renderer);
            }
            catch (IllegalAccessException e) {
                throw new UiException(e.getMessage(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return renderer;
    }

    @Override
    public BindEvaluatorX getEvaluatorX() {
        if (this._eval == null) {
            this._eval = new BindEvaluatorXImpl(null, BindXelFactory.class);
        }
        return this._eval;
    }

    @Override
    public void storeForm(Component comp, String id, Form form) {
        String oldid = (String)comp.getAttribute(FORM_ID, 0);
        if (oldid != null && !oldid.equals(id)) {
            throw new IllegalArgumentException("try to store 2 forms in same component id : 1st " + oldid + ", 2nd " + id);
        }
        Form oldForm = (Form)comp.getAttribute(id);
        if (oldForm == form) {
            return;
        }
        comp.setAttribute(FORM_ID, (Object)id);
        comp.setAttribute(id, (Object)form);
        if (form instanceof FormExt) {
            FormExt fex = (FormExt)((Object)form);
            comp.setAttribute(id + "Status", (Object)fex.getStatus());
            if (oldForm instanceof FormExt) {
                for (String fn : ((FormExt)((Object)oldForm)).getLoadFieldNames()) {
                    fex.addLoadFieldName(fn);
                }
                for (String fn : ((FormExt)((Object)oldForm)).getSaveFieldNames()) {
                    fex.addSaveFieldName(fn);
                }
            }
        }
    }

    @Override
    public Form getForm(Component comp, String id) {
        String oldid = (String)comp.getAttribute(FORM_ID, 0);
        if (oldid == null || !oldid.equals(id)) {
            return null;
        }
        return (Form)comp.getAttribute(id);
    }

    private void removeForm(Component comp) {
        String id = (String)comp.getAttribute(FORM_ID, 0);
        if (id != null) {
            comp.removeAttribute(FORM_ID);
            comp.removeAttribute(id);
            comp.removeAttribute(id + "Status");
        }
    }

    @Override
    public void addFormInitBinding(Component comp, String id, String initExpr, Map<String, Object> initArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("form id is blank", comp));
        }
        if (initExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("initExpr is null for component " + comp + ", form " + id, comp));
        }
        Form form = this.getForm(comp, id);
        if (form == null) {
            this.storeForm(comp, id, new SimpleForm());
        }
        this.addFormInitBinding0(comp, id, initExpr, initArgs);
    }

    private void addFormInitBinding0(Component comp, String formId, String initExpr, Map<String, Object> bindingArgs) {
        if (_log.isDebugEnabled()) {
            _log.debug("add init-form-binding: comp=[%s],form=[%s],expr=[%s]", new Object[]{comp, formId, initExpr});
        }
        String attr = formId;
        InitFormBinding binding = this.newInitFormBinding(comp, attr, initExpr, bindingArgs);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._formBindingHandler.addInitBinding(bkey, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("form-init", comp, null, binding.getPropertyString(), formId, bindingArgs, null));
        }
    }

    @Override
    public void addFormLoadBindings(Component comp, String id, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("form id is blank", comp));
        }
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for component " + comp + ", form " + id, comp));
        }
        Form form = this.getForm(comp, id);
        if (form == null) {
            this.storeForm(comp, id, new SimpleForm());
        }
        this.addFormLoadBindings0(comp, id, loadExpr, beforeCmds, afterCmds, bindingArgs);
    }

    @Override
    public void addFormSaveBindings(Component comp, String id, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("form id is blank", comp));
        }
        if (saveExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("saveExpr is null for component " + comp + ", form " + id, comp));
        }
        Form form = this.getForm(comp, id);
        if (form == null) {
            this.storeForm(comp, id, new SimpleForm());
        }
        this.addFormSaveBindings0(comp, id, saveExpr, beforeCmds, afterCmds, bindingArgs, validatorExpr, validatorArgs);
    }

    private void addFormLoadBindings0(Component comp, String formId, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        String attr = formId;
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (prompt) {
            LoadFormBinding binding = this.newLoadFormBinding(comp, formId, loadExpr, ConditionType.PROMPT, null, bindingArgs);
            this.addBinding(comp, attr, binding);
            BindingKey bkey = this.getBindingKey(comp, attr);
            this._formBindingHandler.addLoadPromptBinding(bkey, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("form-load", comp, null, binding.getPropertyString(), formId, bindingArgs, null));
            }
        } else {
            LoadFormBinding binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = this.newLoadFormBinding(comp, formId, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command-load-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, attr, loadExpr, cmd});
                    }
                    this._formBindingHandler.addLoadBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("form-load", comp, "before = '" + cmd + "'", binding.getPropertyString(), formId, bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = this.newLoadFormBinding(comp, formId, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command-load-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, attr, loadExpr, cmd});
                    }
                    this._formBindingHandler.addLoadAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("form-load", comp, "after = '" + cmd + "'", binding.getPropertyString(), formId, bindingArgs, null));
                }
            }
        }
    }

    private void addFormSaveBindings0(Component comp, String formId, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        BindingKey bkey;
        SaveFormBinding binding;
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        if (prompt) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("a save-form-binding have to set with a before|after command condition", comp));
        }
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (beforeCmds != null && beforeCmds.length > 0) {
            for (String cmd : beforeCmds) {
                binding = this.newSaveFormBinding(comp, formId, saveExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, validatorExpr, validatorArgs);
                this.addBinding(comp, formId, binding);
                if (_log.isDebugEnabled()) {
                    _log.debug("add before command-save-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, formId, saveExpr, cmd});
                }
                this._formBindingHandler.addSaveBeforeBinding(cmd, binding);
                if (collector == null) continue;
                collector.addInfo(new AddBindingInfo("form-save", comp, "before = '" + cmd + "'", formId, binding.getPropertyString(), bindingArgs, null));
            }
        }
        if (afterCmds != null && afterCmds.length > 0) {
            for (String cmd : afterCmds) {
                binding = this.newSaveFormBinding(comp, formId, saveExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, validatorExpr, validatorArgs);
                this.addBinding(comp, formId, binding);
                if (_log.isDebugEnabled()) {
                    _log.debug("add after command-save-form-binding: comp=[%s],attr=[%s],expr=[%s],command=[%s]", new Object[]{comp, formId, saveExpr, cmd});
                }
                this._formBindingHandler.addSaveAfterBinding(cmd, binding);
                if (collector == null) continue;
                collector.addInfo(new AddBindingInfo("form-save", comp, "after = '" + cmd + "'", formId, binding.getPropertyString(), bindingArgs, null));
            }
        }
        if (validatorExpr != null && !this._hasValidators.contains(bkey = this.getBindingKey(comp, formId))) {
            this._hasValidators.add(bkey);
        }
    }

    @Override
    public void addPropertyInitBinding(Component comp, String attr, String initExpr, Map<String, Object> initArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (initExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("initExpr is null for " + attr + " of " + comp, comp));
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + converterExpr + "'";
        }
        this.addPropertyInitBinding0(comp, attr, initExpr, initArgs, converterExpr, converterArgs);
        this.initRendererIfAny(comp, attr);
    }

    @Override
    public void addPropertyLoadBindings(Component comp, String attr, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for component " + comp + ", attr " + attr, comp));
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + converterExpr + "'";
        }
        this.addPropertyLoadBindings0(comp, attr, loadExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs);
        this.initRendererIfAny(comp, attr);
    }

    @Override
    public void addPropertySaveBindings(Component comp, String attr, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        this.checkInit();
        if (saveExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("saveExpr is null for component " + comp + ", attr " + attr, comp));
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + converterExpr + "'";
        }
        if (Strings.isBlank((String)validatorExpr) && (validatorExpr = this.getSystemValidator(comp, attr)) != null) {
            validatorExpr = "'" + validatorExpr + "'";
        }
        this.addPropertySaveBindings0(comp, attr, saveExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
    }

    private void addPropertyInitBinding0(Component comp, String attr, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        String loadrep = null;
        Class attrType = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            loadrep = AnnotationUtil.testString((String[])attrs.get("LOAD_REPLACEMENT"), ann);
            String type = AnnotationUtil.testString((String[])attrs.get("LOAD_TYPE"), ann);
            if (type != null) {
                try {
                    attrType = Classes.forNameByThread((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new UiException(e.getMessage(), (Throwable)e);
                }
            }
        }
        String string = loadrep = loadrep == null ? attr : loadrep;
        if (_log.isDebugEnabled()) {
            _log.debug("add init-binding: comp=[%s],attr=[%s],expr=[%s],converter=[%s]", new Object[]{comp, attr, initExpr, converterArgs});
        }
        InitPropertyBinding binding = this.newInitPropertyBinding(comp, attr, loadrep, attrType, initExpr, bindingArgs, converterExpr, converterArgs);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._propertyBindingHandler.addInitBinding(bkey, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("prop-init", comp, null, binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
        }
    }

    private String getSystemConverter(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return AnnotationUtil.testString((String[])attrs.get("CONVERTER"), ann);
        }
        return null;
    }

    private String getSystemValidator(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return AnnotationUtil.testString((String[])attrs.get("VALIDATOR"), ann);
        }
        return null;
    }

    private void initRendererIfAny(Component comp, String attr) {
        String rendererName;
        Object installed = comp.getAttribute(RENDERER_INSTALLED);
        if (installed != null) {
            return;
        }
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, null);
        Map attrs = ann != null ? ann.getAttributes() : null;
        String installAttr = "model";
        if (attrs != null && "model".equals(attr) && (rendererName = AnnotationUtil.testString((String[])attrs.get("RENDERER"), ann)) != null) {
            String[] values = null;
            values = rendererName.indexOf("=") != -1 ? rendererName.split("=", 2) : rendererName.split(":", 2);
            if (values != null) {
                Object renderer = this.getRenderer(values[1]);
                Object old = null;
                try {
                    old = Fields.get((Object)comp, (String)values[0]);
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
                if (old == null) {
                    try {
                        Fields.set((Object)comp, (String)values[0], (Object)renderer, (boolean)false);
                    }
                    catch (Exception e) {
                        throw new UiException(e.getMessage(), (Throwable)e);
                    }
                    if (renderer instanceof TemplateRendererCtrl) {
                        ((TemplateRendererCtrl)renderer).setAttributeName(attr);
                    }
                }
                comp.setAttribute(RENDERER_INSTALLED, (Object)"");
            }
        }
    }

    protected LoadPropertyBinding newLoadPropertyBinding(Component comp, String attr, String loadAttr, Class<?> attrType, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new LoadPropertyBindingImpl(this, comp, attr, loadAttr, attrType, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
    }

    protected SavePropertyBinding newSavePropertyBinding(Component comp, String attr, String saveAttr, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        return new SavePropertyBindingImpl(this, comp, attr, saveAttr, saveExpr, conditionType, command, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
    }

    protected InitPropertyBinding newInitPropertyBinding(Component comp, String attr, String loadAttr, Class<?> attrType, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new InitPropertyBindingImpl(this, comp, attr, loadAttr, attrType, initExpr, bindingArgs, converterExpr, converterArgs);
    }

    protected InitChildrenBinding newInitChildrenBinding(Component comp, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new InitChildrenBindingImpl(this, comp, initExpr, bindingArgs, converterExpr, converterArgs);
    }

    protected LoadChildrenBinding newLoadChildrenBinding(Component comp, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new LoadChildrenBindingImpl(this, comp, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
    }

    protected CommandBinding newCommandBinding(Component comp, String evtnm, String cmdScript, Map<String, Object> args) {
        return new CommandBindingImpl(this, comp, evtnm, cmdScript, args);
    }

    protected InitFormBinding newInitFormBinding(Component comp, String formId, String initExpr, Map<String, Object> bindingArgs) {
        return new InitFormBindingImpl(this, comp, formId, initExpr, bindingArgs);
    }

    protected LoadFormBinding newLoadFormBinding(Component comp, String formId, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs) {
        return new LoadFormBindingImpl(this, comp, formId, loadExpr, conditionType, command, bindingArgs);
    }

    protected SaveFormBinding newSaveFormBinding(Component comp, String formId, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        return new SaveFormBindingImpl(this, comp, formId, saveExpr, conditionType, command, bindingArgs, validatorExpr, validatorArgs);
    }

    private void addPropertyLoadBindings0(Component comp, String attr, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        String evtnm = null;
        String loadRep = null;
        Class attrType = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = AnnotationUtil.testString((String[])attrs.get("ACCESS"), ann);
            if (rw != null && !"both".equals(rw) && !"load".equals(rw)) {
                return;
            }
            evtnm = AnnotationUtil.testString((String[])attrs.get("LOAD_EVENT"), ann);
            loadRep = AnnotationUtil.testString((String[])attrs.get("LOAD_REPLACEMENT"), ann);
            String type = AnnotationUtil.testString((String[])attrs.get("LOAD_TYPE"), ann);
            if (type != null) {
                try {
                    attrType = Classes.forNameByThread((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw new UiException(e.getMessage(), (Throwable)e);
                }
            }
        }
        String string = loadRep = loadRep == null ? attr : loadRep;
        if (prompt) {
            BindingKey bkey;
            if (_log.isDebugEnabled()) {
                _log.debug("add event(prompt)-load-binding: comp=[%s],attr=[%s],expr=[%s],evtnm=[%s],converter=[%s]", new Object[]{comp, attr, loadExpr, evtnm, converterArgs});
            }
            LoadPropertyBinding binding = this.newLoadPropertyBinding(comp, attr, loadRep, attrType, loadExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
            this.addBinding(comp, attr, binding);
            if (evtnm != null) {
                this.registerCommandEventListener(comp, evtnm);
                this.addBinding(comp, evtnm, binding);
                bkey = this.getBindingKey(comp, evtnm);
                this._propertyBindingHandler.addLoadEventBinding(comp, bkey, binding);
            }
            bkey = this.getBindingKey(comp, attr);
            this._propertyBindingHandler.addLoadPromptBinding(comp, bkey, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("prop-load", comp, evtnm, binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
            }
        } else {
            LoadPropertyBinding binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = this.newLoadPropertyBinding(comp, attr, loadRep, attrType, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command-load-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s]", new Object[]{comp, attr, loadExpr, converterExpr});
                    }
                    this._propertyBindingHandler.addLoadBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-load", comp, "before = '" + cmd + "'", binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = this.newLoadPropertyBinding(comp, attr, loadRep, attrType, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command-load-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s]", new Object[]{comp, attr, loadExpr, converterExpr});
                    }
                    this._propertyBindingHandler.addLoadAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-load", comp, "after = '" + cmd + "'", binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
                }
            }
        }
    }

    private void addPropertySaveBindings0(Component comp, String attr, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        BindingKey bkey;
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        String evtnm = null;
        String saveRep = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = AnnotationUtil.testString((String[])attrs.get("ACCESS"), ann);
            if (!"both".equals(rw) && !"save".equals(rw)) {
                if (BinderUtil.hasContext() && BinderUtil.getContext().isIgnoreAccessCreationWarn()) {
                    return;
                }
                _log.warn(MiscUtil.formatLocationMessage("component " + comp + " doesn't support to save attribute " + attr, comp));
                return;
            }
            evtnm = AnnotationUtil.testString((String[])attrs.get("SAVE_EVENT"), ann);
            saveRep = AnnotationUtil.testString((String[])attrs.get("SAVE_REPLACEMENT"), ann);
        }
        if (evtnm == null) {
            if (BinderUtil.hasContext() && BinderUtil.getContext().isIgnoreAccessCreationWarn()) {
                return;
            }
            _log.warn(MiscUtil.formatLocationMessage("component " + comp + " doesn't has event to save attribute " + attr, comp));
            return;
        }
        String string = saveRep = saveRep == null ? attr : saveRep;
        if (prompt) {
            SavePropertyBinding binding = this.newSavePropertyBinding(comp, attr, saveRep, saveExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
            this.addBinding(comp, attr, binding);
            if (_log.isDebugEnabled()) {
                _log.debug("add event(prompt)-save-binding: comp=[%s],attr=[%s],expr=[%s],evtnm=[%s],converter=[%s],validate=[%s]", new Object[]{comp, attr, saveExpr, evtnm, converterExpr, validatorExpr});
            }
            this.registerCommandEventListener(comp, evtnm);
            this.addBinding(comp, evtnm, binding);
            BindingKey bkey2 = this.getBindingKey(comp, evtnm);
            this._propertyBindingHandler.addSavePromptBinding(comp, bkey2, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("prop-save", comp, null, binding.getFieldName(), binding.getPropertyString(), bindingArgs, null));
            }
        } else {
            SavePropertyBinding binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = this.newSavePropertyBinding(comp, attr, saveRep, saveExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command-save-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s],validator=[%s]", new Object[]{comp, attr, saveExpr, converterExpr, validatorExpr});
                    }
                    this._propertyBindingHandler.addSaveBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-save", comp, "before = '" + cmd + "'", binding.getFieldName(), binding.getPropertyString(), bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = this.newSavePropertyBinding(comp, attr, saveRep, saveExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command-save-binding: comp=[%s],att=r[%s],expr=[%s],converter=[%s],validator=[%s]", new Object[]{comp, attr, saveExpr, converterExpr, validatorExpr});
                    }
                    this._propertyBindingHandler.addSaveAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-save", comp, "after = '" + cmd + "'", binding.getFieldName(), binding.getPropertyString(), bindingArgs, null));
                }
            }
        }
        if (validatorExpr != null && !this._hasValidators.contains(bkey = this.getBindingKey(comp, attr))) {
            this._hasValidators.add(bkey);
        }
    }

    @Override
    @Deprecated
    public void addChildrenInitBinding(Component comp, String initExpr, Map<String, Object> initArgs) {
        this.addChildrenInitBinding(comp, initExpr, initArgs, null, null);
    }

    @Override
    public void addChildrenInitBinding(Component comp, String initExpr, Map<String, Object> initArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (initExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("initExpr is null for children of " + comp, comp));
        }
        this.addChildrenInitBinding0(comp, initExpr, initArgs, converterExpr, converterArgs);
    }

    @Override
    @Deprecated
    public void addChildrenLoadBindings(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        this.addChildrenLoadBindings(comp, loadExpr, beforeCmds, afterCmds, bindingArgs, null, null);
    }

    @Override
    public void addChildrenLoadBindings(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for children of " + comp, comp));
        }
        this.addChildrenLoadBindings0(comp, loadExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs);
    }

    private void addChildrenInitBinding0(Component comp, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        if (_log.isDebugEnabled()) {
            _log.debug("add children-init-binding: comp=[%s],expr=[%s]", (Object)comp, (Object)initExpr);
        }
        InitChildrenBinding binding = this.newInitChildrenBinding(comp, initExpr, bindingArgs, converterExpr, converterArgs);
        this.addBinding(comp, CHILDREN_ATTR, binding);
        BindingKey bkey = this.getBindingKey(comp, CHILDREN_ATTR);
        this._childrenBindingHandler.addInitBinding(bkey, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("children-init", comp, null, binding.getPropertyString(), null, bindingArgs, null));
        }
    }

    private void addChildrenLoadBindings0(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (prompt) {
            if (_log.isDebugEnabled()) {
                _log.debug("add event(prompt)-children-load-binding: comp=[%s],expr=[%s]", (Object)comp, (Object)loadExpr);
            }
            LoadChildrenBindingImpl binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
            this.addBinding(comp, CHILDREN_ATTR, binding);
            BindingKey bkey = this.getBindingKey(comp, CHILDREN_ATTR);
            this._childrenBindingHandler.addLoadPromptBinding(comp, bkey, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("children-load", comp, null, binding.getPropertyString(), null, bindingArgs, null));
            }
        } else {
            LoadChildrenBindingImpl binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, CHILDREN_ATTR, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command children-load-binding: comp=[%s],expr=[%s],cmd=[%s]", new Object[]{comp, loadExpr, cmd});
                    }
                    this._childrenBindingHandler.addLoadBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("children-load", comp, "before = '" + cmd + "'", binding.getPropertyString(), null, bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, CHILDREN_ATTR, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command children-load-binding: comp=[%s],expr=[%s],cmd=[%s]", new Object[]{comp, loadExpr, cmd});
                    }
                    this._childrenBindingHandler.addLoadAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("children-load", comp, "after = '" + cmd + "'", binding.getPropertyString(), null, bindingArgs, null));
                }
            }
        }
    }

    @Override
    public void addReferenceBinding(Component comp, String attr, String loadExpr, Map<String, Object> bindingArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for reference of " + comp, comp));
        }
        this.addReferenceBinding0(comp, attr, loadExpr, bindingArgs);
    }

    private void addReferenceBinding0(Component comp, String attr, String loadExpr, Map<String, Object> bindingArgs) {
        if (_log.isDebugEnabled()) {
            _log.debug("add reference-binding: comp=[%s],attr=[%s],expr=[%s]", new Object[]{comp, attr, loadExpr});
        }
        ReferenceBindingImpl binding = new ReferenceBindingImpl(this, comp, attr, loadExpr);
        if (this._refBindingHandler == null) {
            throw new UiException(MiscUtil.formatLocationMessage("ref binding handler is not supported in current runtime.", comp));
        }
        this._refBindingHandler.addReferenceBinding(comp, attr, binding);
        this.addBinding(comp, attr, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("reference", comp, null, binding.getPropertyString(), "self." + attr, bindingArgs, null));
        }
    }

    private boolean isPrompt(String[] beforeCmds, String[] afterCmds) {
        return !(beforeCmds != null && beforeCmds.length != 0 || afterCmds != null && afterCmds.length != 0);
    }

    @Override
    public void addCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        this.checkInit();
        CommandBinding binding = this.newCommandBinding(comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.registerCommandEventListener(comp, evtnm, binding, false);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddCommandBindingInfo("viewmodel", comp, evtnm, binding.getCommandString(), args, null));
        }
    }

    @Override
    public void addGlobalCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        this.checkInit();
        CommandBinding binding = this.newCommandBinding(comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.registerCommandEventListener(comp, evtnm, binding, true);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddCommandBindingInfo("global", comp, evtnm, binding.getCommandString(), args, null));
        }
    }

    private void registerCommandEventListener(Component comp, String evtnm, CommandBinding command, boolean global) {
        CommandEventListener listener = this.getCommandEventListener(comp, evtnm);
        if (global) {
            listener.setGlobalCommand(command);
        } else {
            listener.setCommand(command);
        }
    }

    private void registerCommandEventListener(Component comp, String evtnm) {
        CommandEventListener listener = this.getCommandEventListener(comp, evtnm);
        listener.setPrompt(true);
    }

    private CommandEventListener getCommandEventListener(Component comp, String evtnm) {
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        CommandEventListener listener = this._listenerMap.get(bkey);
        if (listener == null) {
            listener = new CommandEventListener(comp);
            comp.addEventListener(evtnm, (EventListener)listener);
            this._listenerMap.put(bkey, listener);
        }
        return listener;
    }

    private void removeEventCommandListenerIfExists(Component comp, String evtnm) {
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        CommandEventListener listener = this._listenerMap.remove(bkey);
        if (listener != null) {
            comp.removeEventListener(evtnm, (EventListener)listener);
        }
    }

    @Override
    public boolean isActivating() {
        return this._activating;
    }

    private void notifyVMsgsChanged() {
        if (this._validationMessages != null) {
            Events.postEvent((int)-1, (Component)this._dummyTarget, (Event)new Event(ON_VMSGS_CHANGED));
        }
    }

    @Override
    public void sendCommand(String command, Map<String, Object> args) {
        this.checkInit();
        HashSet<Property> notifys = new HashSet<Property>();
        this.doCommand(this._rootComp, null, command, null, args, notifys);
        this.fireNotifyChanges(notifys);
    }

    private void fireNotifyChanges(Set<Property> notifys) {
        for (Property prop : notifys) {
            this.notifyChange(prop.getBase(), prop.getProperty());
        }
    }

    @Override
    public void postCommand(String command, Map<String, Object> args) {
        this.checkInit();
        Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{command, args});
        Events.postEvent((Event)evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCommand(Component comp, CommandBinding commandBinding, String command, Event evt, Map<String, Object> commandArgs, Set<Property> notifys) {
        String evtnm;
        String string = evtnm = evt == null ? null : evt.getName();
        if (_log.isDebugEnabled()) {
            _log.debug("Start doCommand comp=[%s],command=[%s],evtnm=[%s]", new Object[]{comp, command, evtnm});
        }
        BindContext ctx = BindContextUtil.newBindContext(this, commandBinding, false, command, comp, evt);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.COMMAND, ctx);
            boolean success = true;
            BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
            if (collector != null) {
                collector.addInfo(new CommandInfo("on-command", comp, evtnm, commandBinding == null ? null : BindEvaluatorXUtil.getExpressionString(((CommandBindingImpl)commandBinding).getCommand()), command, commandArgs, null));
            }
            if (!(success = this.doValidate(comp, command, evt, ctx, notifys))) {
                int n = 1;
                return n;
            }
            this.doSaveBefore(comp, command, evt, ctx, notifys);
            this.doLoadBefore(comp, command, ctx);
            this.doExecute(comp, command, commandArgs, ctx, notifys);
            this.doSaveAfter(comp, command, evt, ctx, notifys);
            this.doLoadAfter(comp, command, ctx);
            if (_log.isDebugEnabled()) {
                _log.debug("End doCommand");
            }
            int n = 0;
            return n;
        }
        finally {
            this.doPostPhase(Phase.COMMAND, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGlobalCommand(Component comp, String command, Map<String, Object> commandArgs, Set<Property> notifys) {
        if (_log.isDebugEnabled()) {
            _log.debug("Start doGlobalCommand comp=[%s],command=[%s]", (Object)comp, (Object)command);
        }
        BindContext ctx = BindContextUtil.newBindContext(this, null, false, command, comp, null);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.GLOBAL_COMMAND, ctx);
            BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
            if (collector != null) {
                collector.addInfo(new CommandInfo("on-command-global", comp, null, null, command, commandArgs, null));
            }
            this.doGlobalCommandExecute(comp, command, commandArgs, ctx, notifys);
        }
        finally {
            this.doPostPhase(Phase.GLOBAL_COMMAND, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGlobalCommandExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("before doGlobalCommandExecute comp=[%s],command=[%s]", (Object)comp, (Object)command);
            }
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object viewModel = this.getViewModel();
            Method method = this.getCommandMethod(viewModel.getClass(), command, _globalCommandMethodInfoProvider, _globalCommandMethodCache);
            if (method != null) {
                BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
                if (collector != null) {
                    collector.addInfo(new CommandInfo("execute-global", comp, null, null, command, commandArgs, method.toString()));
                }
                ParamCall parCall = this.createParamCall(ctx);
                if (commandArgs != null) {
                    parCall.setBindingArgs(commandArgs);
                }
                parCall.call(viewModel, method);
                notifys.addAll(BindELContext.getNotifys(method, viewModel, null, null, ctx));
            } else if (_log.isDebugEnabled()) {
                _log.debug("no global command method in [%s]", viewModel);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("after doGlobalCommandExecute notifys=[%s]", notifys);
            }
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    void doPrePhase(Phase phase, BindContext ctx) {
        PhaseListener listener;
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.pushStack(phase.name());
        }
        if ((listener = this.getPhaseListener()) != null) {
            listener.prePhase(phase, ctx);
        }
    }

    void doPostPhase(Phase phase, BindContext ctx) {
        BindingExecutionInfoCollector collector;
        PhaseListener listener = this.getPhaseListener();
        if (listener != null) {
            listener.postPhase(phase, ctx);
        }
        if ((collector = this.getBindingExecutionInfoCollector()) != null) {
            collector.popStack();
        }
    }

    private boolean doSaveEvent(Component comp, Event evt, Set<Property> notifys) {
        String evtnm;
        String string = evtnm = evt == null ? null : evt.getName();
        if (_log.isDebugEnabled()) {
            _log.debug("doSaveEvent comp=[%s],evtnm=[%s],notifys=[%s]", new Object[]{comp, evtnm, notifys});
        }
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        return this._propertyBindingHandler.doSaveEvent(bkey, comp, evt, notifys);
    }

    private void doLoadEvent(Component comp, Event evt) {
        if (_log.isDebugEnabled()) {
            _log.debug("doLoadEvent comp=[%s],evtnm=[%s]", (Object)comp, (Object)evt.getName());
        }
        BindingKey bkey = this.getBindingKey(comp, evt.getName());
        this._propertyBindingHandler.doLoadEvent(bkey, comp, evt);
    }

    private boolean doValidate(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        HashSet<Property> validates = new HashSet<Property>();
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("doValidate comp=[%s],command=[%s],evt=[%s],context=[%s]", new Object[]{comp, command, evt, ctx});
            }
            this.doPrePhase(Phase.VALIDATE, ctx);
            ValidationHelper vHelper = new ValidationHelper(this, new ValidationHelper.InfoProvider(){

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormBeforeBindings() {
                    return BinderImpl.this._formBindingHandler.getSaveFormBeforeBindings();
                }

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormAfterBindings() {
                    return BinderImpl.this._formBindingHandler.getSaveFormAfterBindings();
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveBeforeBindings() {
                    return BinderImpl.this._propertyBindingHandler.getSaveBeforeBindings();
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveAfterBindings() {
                    return BinderImpl.this._propertyBindingHandler.getSaveAfterBindings();
                }

                @Override
                public BindingKey getBindingKey(Component comp, String attr) {
                    return BinderImpl.this.getBindingKey(comp, attr);
                }
            });
            vHelper.collectSaveBefore(comp, command, evt, validates);
            vHelper.collectSaveAfter(comp, command, evt, validates);
            if (validates.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("doValidate validates=[%s]", validates);
            }
            boolean valid = true;
            for (Property p : validates) {
                if (!(p instanceof WrongValuePropertyImpl)) continue;
                for (WrongValueException wve : ((WrongValuePropertyImpl)p).getWrongValueExceptions()) {
                    Component wvc = wve.getComponent();
                    if (wvc == null || (wve = ((ComponentCtrl)wvc).onWrongValue(wve)) == null) continue;
                    Component c = wve.getComponent();
                    if (c == null) {
                        c = wvc;
                    }
                    Clients.wrongValue((Component)c, (String)wve.getMessage());
                }
                valid = false;
            }
            Map<String, Property[]> properties = this._propertyBindingHandler.toCollectedProperties(validates);
            valid &= vHelper.validateSaveBefore(comp, command, properties, valid, notifys);
            valid &= vHelper.validateSaveAfter(comp, command, properties, valid, notifys);
            boolean bl = valid;
            return bl;
        }
        catch (Exception e) {
            throw new UiException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.doPostPhase(Phase.VALIDATE, ctx);
        }
    }

    protected ParamCall createParamCall(BindContext ctx) {
        Execution exec;
        ParamCall call = new ParamCall();
        call.setBinder(this);
        call.setBindContext(ctx);
        Component comp = ctx.getComponent();
        if (comp != null) {
            call.setComponent(comp);
        }
        if ((exec = Executions.getCurrent()) != null) {
            call.setExecution(exec);
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        try {
            ParamCall parCall;
            if (_log.isDebugEnabled()) {
                _log.debug("before doExecute comp=[%s],command=[%s],notifys=[%s]", new Object[]{comp, command, notifys});
            }
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object viewModel = this.getViewModel();
            Method method = this.getCommandMethod(viewModel.getClass(), command, _commandMethodInfoProvider, _commandMethodCache);
            if (method != null) {
                BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
                if (collector != null) {
                    collector.addInfo(new CommandInfo("execute", comp, null, null, command, commandArgs, method.toString()));
                }
                parCall = this.createParamCall(ctx);
                if (commandArgs != null) {
                    parCall.setBindingArgs(commandArgs);
                }
            } else {
                throw new UiException(MiscUtil.formatLocationMessage("cannot find any method that is annotated for the command " + command + " with @Command in " + viewModel, comp));
            }
            parCall.call(viewModel, method);
            notifys.addAll(BindELContext.getNotifys(method, viewModel, null, null, ctx));
            if (_log.isDebugEnabled()) {
                _log.debug("after doExecute notifys=[%s]", notifys);
            }
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCommandMethod(Class<?> clz, String command, CommandMethodInfoProvider cmdInfo, Map<Class<?>, Map<String, CachedItem<Method>>> cache) {
        Map<String, CachedItem<Method>> methods;
        Map<Class<?>, Map<String, CachedItem<Method>>> map = cache;
        synchronized (map) {
            methods = cache.get(clz);
            if (methods == null) {
                methods = new HashMap<String, CachedItem<Method>>();
                cache.put(clz, methods);
            }
        }
        CachedItem<Method> method = null;
        Map<String, CachedItem<Method>> map2 = methods;
        synchronized (map2) {
            method = methods.get(command);
            if (method != null) {
                return (Method)method.value;
            }
            if (methods.get(COMMAND_METHOD_MAP_INIT) != null) {
                method = methods.get(COMMAND_METHOD_DEFAULT);
                if (method != null) {
                    return (Method)method.value;
                }
                return null;
            }
            methods.clear();
            for (Method m : clz.getMethods()) {
                String[] vals;
                if (cmdInfo.isDefaultMethod(m)) {
                    if (methods.get(COMMAND_METHOD_DEFAULT) != null) {
                        throw new UiException("there are more than one " + cmdInfo.getDefaultAnnotationName() + " method in " + clz + ", " + methods.get((Object)COMMAND_METHOD_DEFAULT).value + " and " + m);
                    }
                    methods.put(COMMAND_METHOD_DEFAULT, new CachedItem<Method>(m));
                }
                if ((vals = cmdInfo.getCommandName(m)) == null) continue;
                if (vals.length == 0) {
                    vals = new String[]{m.getName()};
                }
                for (String val : vals) {
                    if (methods.get(val = val.trim()) != null) {
                        throw new UiException("there are more than one " + cmdInfo.getAnnotationName() + " method " + val + " in " + clz + ", " + methods.get((Object)val).value + " and " + m);
                    }
                    methods.put(val, new CachedItem<Method>(m));
                }
            }
            methods.put(COMMAND_METHOD_MAP_INIT, NULL_METHOD);
        }
        method = methods.get(command);
        if (method != null) {
            return (Method)method.value;
        }
        method = methods.get(COMMAND_METHOD_DEFAULT);
        return method == null ? null : (Method)method.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveBefore(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        if (_log.isDebugEnabled()) {
            _log.debug("doSaveBefore, comp=[%s],command=[%s],evt=[%s],notifys=[%s]", new Object[]{comp, command, evt, notifys});
        }
        try {
            this.doPrePhase(Phase.SAVE_BEFORE, ctx);
            this._propertyBindingHandler.doSaveBefore(comp, command, evt, notifys);
            this._formBindingHandler.doSaveBefore(comp, command, evt, notifys);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BEFORE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveAfter(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        if (_log.isDebugEnabled()) {
            _log.debug("doSaveAfter, comp=[%s],command=[%s],evt=[%s],notifys=[%s]", new Object[]{comp, command, evt, notifys});
        }
        try {
            this.doPrePhase(Phase.SAVE_AFTER, ctx);
            this._propertyBindingHandler.doSaveAfter(comp, command, evt, notifys);
            this._formBindingHandler.doSaveAfter(comp, command, evt, notifys);
        }
        finally {
            this.doPostPhase(Phase.SAVE_AFTER, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadBefore(Component comp, String command, BindContext ctx) {
        if (_log.isDebugEnabled()) {
            _log.debug("doLoadBefore, comp=[%s],command=[%s]", (Object)comp, (Object)command);
        }
        try {
            this.doPrePhase(Phase.LOAD_BEFORE, ctx);
            this._propertyBindingHandler.doLoadBefore(comp, command);
            this._formBindingHandler.doLoadBefore(comp, command);
            this._childrenBindingHandler.doLoadBefore(comp, command);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BEFORE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadAfter(Component comp, String command, BindContext ctx) {
        if (_log.isDebugEnabled()) {
            _log.debug("doLoadAfter, comp=[%s],command=[%s]", (Object)comp, (Object)command);
        }
        try {
            this.doPrePhase(Phase.LOAD_AFTER, ctx);
            this._propertyBindingHandler.doLoadAfter(comp, command);
            this._formBindingHandler.doLoadAfter(comp, command);
            this._childrenBindingHandler.doLoadAfter(comp, command);
        }
        finally {
            this.doPostPhase(Phase.LOAD_AFTER, ctx);
        }
    }

    @Override
    public void removeBindings(Set<Component> comps) {
        for (Component comp : comps) {
            this.removeBindings0(comp);
        }
        TrackerImpl tracker = (TrackerImpl)this.getTracker();
        tracker.removeTrackings(comps);
    }

    @Override
    public void removeBindings(Component comp) {
        this.removeBindings0(comp);
        TrackerImpl tracker = (TrackerImpl)this.getTracker();
        tracker.removeTrackings(comp);
    }

    private void removeBindings0(Component comp) {
        Map<String, List<Binding>> attrMap;
        this.checkInit();
        if (this._rootComp == comp) {
            this.unsubscribeQueue(this._quename, this._quescope, this._queueListener);
            this._rootComp.removeAttribute(ACTIVATOR);
        }
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp);
        }
        if ((attrMap = this._bindings.remove(comp)) != null) {
            HashSet<Binding> removed = new HashSet<Binding>();
            for (Map.Entry<String, List<Binding>> entry : attrMap.entrySet()) {
                String key = entry.getKey();
                this.removeBindings(comp, key);
                removed.addAll((Collection<Binding>)entry.getValue());
            }
            if (!removed.isEmpty()) {
                this.removeBindings((Collection<Binding>)removed);
            }
        }
        this.removeFormAssociatedSaveBinding(comp);
        this.removeForm(comp);
        this.removeTemplateResolver(comp);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.removeReferenceBinding(comp);
        }
        BinderUtil.unmarkHandling(comp);
    }

    @Override
    public void removeBindings(Component comp, String key) {
        this.checkInit();
        this.removeEventCommandListenerIfExists(comp, key);
        BindingKey bkey = this.getBindingKey(comp, key);
        HashSet<Binding> removed = new HashSet<Binding>();
        this._formBindingHandler.removeBindings(bkey, removed);
        this._propertyBindingHandler.removeBindings(bkey, removed);
        this._childrenBindingHandler.removeBindings(bkey, removed);
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp, key);
        }
        this._hasValidators.remove(bkey);
        this.removeTemplateResolver(comp, key);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.removeReferenceBinding(comp, key);
        }
        this.removeBindings((Collection<Binding>)removed);
    }

    @Override
    public List<Binding> getLoadPromptBindings(Component comp, String attr) {
        List<LoadChildrenBinding> childrenLoadBindings;
        this.checkInit();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BindingKey bkey = this.getBindingKey(comp, attr);
        List<LoadPropertyBinding> loadBindings = this._propertyBindingHandler.getLoadPromptBindings(bkey);
        if (loadBindings != null && loadBindings.size() > 0) {
            bindings.addAll(loadBindings);
        }
        if (bindings.size() == 0 && (childrenLoadBindings = this._childrenBindingHandler.getLoadPromptBindings(bkey)) != null && childrenLoadBindings.size() > 0) {
            bindings.addAll(childrenLoadBindings);
        }
        return bindings;
    }

    private void removeBindings(Collection<Binding> removed) {
        this._formBindingHandler.removeBindings(removed);
        this._propertyBindingHandler.removeBindings(removed);
        this._childrenBindingHandler.removeBindings(removed);
    }

    private void addBinding(Component comp, String attr, Binding binding) {
        Map<String, List<Binding>> attrMap = this._bindings.get(comp);
        List<Binding> bindings = attrMap == null ? null : attrMap.get(attr);
        bindings = AllocUtil.inst.addList(bindings, binding);
        attrMap = AllocUtil.inst.putLinkedHashMap(attrMap, attr, bindings);
        this._bindings.put(comp, attrMap);
        BinderUtil.markHandling(comp, this);
    }

    @Override
    public void setTemplate(Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        if (resolvers == null) {
            resolvers = new HashMap<String, TemplateResolver>();
            this._templateResolvers.put(comp, resolvers);
        }
        resolvers.put(attr, this.newTemplateResolverImpl(this, comp, attr, templateExpr, templateArgs));
    }

    private TemplateResolver newTemplateResolverImpl(BinderImpl binderImpl, Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        String clznm = Library.getProperty((String)"org.zkoss.bind.TemplateResolver.class", (String)TemplateResolverImpl.class.getName());
        try {
            Class clz = Classes.forNameByThread((String)clznm);
            Constructor c = clz.getDeclaredConstructor(Binder.class, Component.class, String.class, String.class, Map.class);
            TemplateResolver resolver = (TemplateResolver)c.newInstance(binderImpl, comp, attr, templateExpr, templateArgs);
            return resolver;
        }
        catch (Exception e) {
            throw new UiException("Can't initialize template resolver ", (Throwable)e);
        }
    }

    @Override
    public TemplateResolver getTemplateResolver(Component comp, String attr) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        return resolvers == null ? null : resolvers.get(attr);
    }

    private void removeTemplateResolver(Component comp, String attr) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        if (resolvers != null) {
            resolvers.remove(attr);
        }
    }

    private void removeTemplateResolver(Component comp) {
        this._templateResolvers.remove(comp);
    }

    @Override
    public Tracker getTracker() {
        if (this._tracker == null) {
            String clznm = Library.getProperty((String)"org.zkoss.bind.Tracker.class");
            if (clznm != null) {
                try {
                    Class clz = Classes.forNameByThread((String)clznm);
                    this._tracker = (Tracker)clz.newInstance();
                }
                catch (Exception e) {
                    throw new UiException("Can't initialize tracker", (Throwable)e);
                }
            } else {
                this._tracker = new TrackerImpl();
            }
        }
        return this._tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadComponent(Component comp, boolean loadinit) {
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        this.loadComponent0(comp, loadinit);
    }

    private void loadComponent0(Component comp, boolean loadinit) {
        this.loadComponentProperties0(comp, loadinit);
        for (Component kid = comp.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            this.loadComponent0(kid, loadinit);
        }
    }

    private void loadComponentProperties0(Component comp, boolean loadinit) {
        Map<String, List<Binding>> compBindings = this._bindings.get(comp);
        if (compBindings != null) {
            BindingKey bkey;
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                if (loadinit) {
                    this._formBindingHandler.doInit(comp, bkey);
                }
                this._formBindingHandler.doLoad(comp, bkey);
            }
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                if (loadinit) {
                    this._propertyBindingHandler.doInit(comp, bkey);
                }
                this._propertyBindingHandler.doLoad(comp, bkey);
            }
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                if (loadinit) {
                    this._childrenBindingHandler.doInit(comp, bkey);
                }
                this._childrenBindingHandler.doLoad(comp, bkey);
            }
        }
    }

    @Override
    public void notifyChange(Object base, String attr) {
        this.checkInit();
        if (_log.isDebugEnabled()) {
            _log.debug("notifyChange base=[%s],attr=[%s]", base, (Object)attr);
        }
        this.getEventQueue().publish((Event)new PropertyChangeEvent(this._rootComp, base, attr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postGlobalCommand(Component comp, CommandBinding commandBinding, String command, Event evt, Map<String, Object> args) {
        if (_log.isDebugEnabled()) {
            _log.debug("postGlobalCommand command=[%s], args=[%s]", (Object)command, args);
        }
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        try {
            if (collector != null) {
                collector.pushStack("POST_GLOBAL_COMMAND");
                collector.addInfo(new CommandInfo("post-global", comp, evt == null ? null : evt.getName(), BindEvaluatorXUtil.getExpressionString(((CommandBindingImpl)commandBinding).getCommand()), command, args, null));
            }
            this.getEventQueue().publish((Event)new GlobalCommandEvent(this._rootComp, command, args));
        }
        finally {
            if (collector != null) {
                collector.popStack();
            }
        }
    }

    @Override
    public void setPhaseListener(PhaseListener listener) {
        this._phaseListener = listener;
        this._phaseListenerSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PhaseListener getPhaseListener() {
        if (this._phaseListenerSet) {
            return this._phaseListener;
        }
        if (_sharedPhaseListenerSet) return _sharedPhaseListener;
        Class<BinderImpl> clazz = BinderImpl.class;
        synchronized (BinderImpl.class) {
            _sharedPhaseListenerSet = true;
            String clz = Library.getProperty((String)"org.zkoss.bind.PhaseListener.class");
            if (Strings.isEmpty((String)clz)) return _sharedPhaseListener;
            try {
                _sharedPhaseListener = (PhaseListener)Classes.forNameByThread((String)clz).newInstance();
            }
            catch (Exception e) {
                _log.error("Error when initial phase listener:" + clz, (Throwable)e);
            }
            return _sharedPhaseListener;
        }
    }

    private void subscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)true);
        que.subscribe(listener);
    }

    private void unsubscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        if (que != null) {
            que.unsubscribe(listener);
        }
    }

    private boolean isSubscribed(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        return que == null ? false : que.isSubscribed(listener);
    }

    protected EventQueue<Event> getEventQueue() {
        return EventQueues.lookup((String)this._quename, (String)this._quescope, (boolean)true);
    }

    private BindingKey getBindingKey(Component comp, String attr) {
        return new BindingKey(comp, attr);
    }

    private void removeFormAssociatedSaveBinding(Component comp) {
        this._assocFormSaveBindings.remove(comp);
        Map<SaveBinding, Set<SaveBinding>> associated = this._reversedAssocFormSaveBindings.remove(comp);
        if (associated != null) {
            Set<Map.Entry<SaveBinding, Set<SaveBinding>>> entries = associated.entrySet();
            for (Map.Entry<SaveBinding, Set<SaveBinding>> entry : entries) {
                entry.getValue().remove(entry.getKey());
            }
        }
    }

    @Override
    public void addFormAssociatedSaveBinding(Component associatedComp, String formId, SaveBinding saveBinding, String fieldName) {
        this.checkInit();
        Component formComp = this.lookupAossicatedFormComponent(formId, associatedComp);
        if (formComp == null) {
            throw new UiException("cannot find any form " + formId + " with " + associatedComp);
        }
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(formComp);
        if (bindings == null) {
            bindings = new LinkedHashSet<SaveBinding>();
            this._assocFormSaveBindings.put(formComp, bindings);
        }
        bindings.add(saveBinding);
        Map<SaveBinding, Set<SaveBinding>> reverseMap = this._reversedAssocFormSaveBindings.get(associatedComp);
        if (reverseMap == null) {
            reverseMap = new HashMap<SaveBinding, Set<SaveBinding>>();
            this._reversedAssocFormSaveBindings.put(associatedComp, reverseMap);
        }
        reverseMap.put(saveBinding, bindings);
        ((SavePropertyBindingImpl)saveBinding).setFormFieldInfo(formComp, formId, fieldName);
    }

    private Component lookupAossicatedFormComponent(String formId, Component associatedComp) {
        Component p;
        String fid = null;
        for (p = associatedComp; !(p == null || (fid = (String)p.getAttribute(FORM_ID)) != null && fid.equals(formId)); p = p.getParent()) {
        }
        return p;
    }

    @Override
    public Set<SaveBinding> getFormAssociatedSaveBindings(Component comp) {
        this.checkInit();
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(comp);
        if (bindings == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<SaveBinding>(bindings);
    }

    @Override
    public boolean hasValidator(Component comp, String attr) {
        BindingKey bkey = this.getBindingKey(comp, attr);
        return this._hasValidators.contains(bkey);
    }

    @Override
    public Component getView() {
        this.checkInit();
        return this._rootComp;
    }

    @Override
    public ValidationMessages getValidationMessages() {
        return this._validationMessages;
    }

    @Override
    public void setValidationMessages(ValidationMessages messages) {
        this._validationMessages = messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void didActivate() {
        this._activating = true;
        try {
            _log.debug("didActivate : [%s]", (Object)this);
            this.loadComponent(this._rootComp, false);
        }
        finally {
            this._activating = false;
        }
    }

    @Override
    public BindingExecutionInfoCollector getBindingExecutionInfoCollector() {
        DebuggerFactory factory = DebuggerFactory.getInstance();
        return factory == null ? null : factory.getExecutionInfoCollector();
    }

    @Override
    public BindingAnnotationInfoChecker getBindingAnnotationInfoChecker() {
        DebuggerFactory factory = DebuggerFactory.getInstance();
        return factory == null ? null : factory.getAnnotationInfoChecker();
    }

    static {
        _sharedPhaseListenerSet = false;
    }

    private class DeferredActivator
    implements ExecutionInit,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DeferredActivator() {
        }

        public void init(Execution exec, Execution parent) throws Exception {
            Desktop desktop = exec.getDesktop();
            desktop.removeListener((Object)BinderImpl.this._deferredActivator);
            BinderImpl.this.didActivate();
        }
    }

    private class Activator
    implements ComponentActivationListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Activator() {
        }

        public void didActivate(Component comp) {
            if (BinderImpl.this._rootComp.equals(comp)) {
                if (!BinderImpl.this.isSubscribed(BinderImpl.this._quename, BinderImpl.this._quescope, (EventListener<Event>)BinderImpl.this._queueListener)) {
                    BinderImpl.this.subscribeQueue(BinderImpl.this._quename, BinderImpl.this._quescope, (EventListener<Event>)BinderImpl.this._queueListener);
                }
                if (BinderImpl.this._deferredActivator == null) {
                    comp.getDesktop().addListener((Object)(BinderImpl.this._deferredActivator = new DeferredActivator()));
                }
            }
        }

        public void willPassivate(Component comp) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedItem<T> {
        final T value;

        public CachedItem(T value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostCommandListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PostCommandListener() {
        }

        public void onEvent(Event event) throws Exception {
            Object[] data = (Object[])event.getData();
            String command = (String)data[0];
            Map args = (Map)data[1];
            BinderImpl.this.sendCommand(command, args);
        }
    }

    private static interface CommandMethodInfoProvider {
        public String getAnnotationName();

        public String getDefaultAnnotationName();

        public String[] getCommandName(Method var1);

        public boolean isDefaultMethod(Method var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VMsgsChangedListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VMsgsChangedListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (BinderImpl.this._validationMessages != null) {
                HashSet<PropertyImpl> notify = new HashSet<PropertyImpl>();
                notify.add(new PropertyImpl(BinderImpl.this._validationMessages, ".", null));
                BinderImpl.this.fireNotifyChanges(notify);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandEventListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean _prompt = false;
        private CommandBinding _commandBinding;
        private CommandBinding _globalCommandBinding;
        private final Component _target;

        CommandEventListener(Component target) {
            this._target = target;
        }

        private void setCommand(CommandBinding command) {
            this._commandBinding = command;
        }

        private void setGlobalCommand(CommandBinding command) {
            this._globalCommandBinding = command;
        }

        private void setPrompt(boolean prompt) {
            this._prompt = prompt;
        }

        public void onEvent(Event event) throws Exception {
            BindingExecutionInfoCollector collector = BinderImpl.this.getBindingExecutionInfoCollector();
            try {
                if (collector != null) {
                    collector.pushStack("ON_EVENT");
                    collector.addInfo(new EventInfo(event.getTarget(), event.getName(), null));
                }
                this.onEvent0(event);
            }
            catch (Exception x) {
                _log.error(x.getMessage(), (Throwable)x);
                throw x;
            }
            finally {
                if (collector != null) {
                    collector.popStack();
                }
            }
        }

        private void onEvent0(Event event) throws Exception {
            Map<String, Object> args;
            Map<String, Object> implicit;
            BindEvaluatorX eval;
            Component comp = this._target;
            String evtnm = event.getName();
            LinkedHashSet notifys = new LinkedHashSet();
            int cmdResult = 0;
            boolean promptResult = true;
            String command = null;
            if (_log.isDebugEnabled()) {
                _log.debug("====Start command event [%s]", (Object)event);
            }
            if (this._prompt) {
                promptResult = BinderImpl.this.doSaveEvent(comp, event, notifys);
            }
            if (this._commandBinding != null && !Strings.isEmpty((String)(command = (String)(eval = BinderImpl.this.getEvaluatorX()).getValue(null, comp, ((CommandBindingImpl)this._commandBinding).getCommand())))) {
                implicit = null;
                if (BinderImpl.this._implicitContributor != null) {
                    implicit = BinderImpl.this._implicitContributor.contirbuteCommandObject(BinderImpl.this, this._commandBinding, event);
                }
                args = BindEvaluatorXUtil.evalArgs(eval, comp, this._commandBinding.getArgs(), implicit);
                cmdResult = BinderImpl.this.doCommand(comp, this._commandBinding, command, event, args, notifys);
            }
            if (this._prompt && promptResult) {
                if (_log.isDebugEnabled()) {
                    _log.debug("This is a prompt command");
                }
                BinderImpl.this.doLoadEvent(comp, event);
            }
            BinderImpl.this.notifyVMsgsChanged();
            if (_log.isDebugEnabled()) {
                _log.debug("There are [%s] property need to be notify after event = [%s], command = [%s]", new Object[]{notifys.size(), evtnm, command});
            }
            BinderImpl.this.fireNotifyChanges(notifys);
            if (cmdResult == 0 && this._globalCommandBinding != null && !Strings.isEmpty((String)(command = (String)(eval = BinderImpl.this.getEvaluatorX()).getValue(null, comp, ((CommandBindingImpl)this._globalCommandBinding).getCommand())))) {
                implicit = null;
                if (BinderImpl.this._implicitContributor != null) {
                    implicit = BinderImpl.this._implicitContributor.contirbuteCommandObject(BinderImpl.this, this._commandBinding, event);
                }
                args = BindEvaluatorXUtil.evalArgs(eval, comp, this._globalCommandBinding.getArgs(), implicit);
                BinderImpl.this.postGlobalCommand(comp, this._globalCommandBinding, command, event, args);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("====End command event [%s]", (Object)event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private QueueListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (event instanceof PropertyChangeEvent) {
                PropertyChangeEvent evt = (PropertyChangeEvent)event;
                BinderImpl.this.doPropertyChange(evt.getBase(), evt.getProperty());
            } else if (event instanceof GlobalCommandEvent) {
                GlobalCommandEvent evt = (GlobalCommandEvent)event;
                LinkedHashSet notifys = new LinkedHashSet();
                BinderImpl.this.doGlobalCommand(BinderImpl.this._rootComp, evt.getCommand(), evt.getArgs(), notifys);
                BinderImpl.this.fireNotifyChanges(notifys);
                BinderImpl.this.notifyVMsgsChanged();
            }
        }
    }
}

