/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.sys.debugger.impl.info;

import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.sys.debugger.ExecutionInfo;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.ui.Component;

public class ExecutionInfoBase
implements ExecutionInfo {
    Component _comp;
    String _type;
    String _subtype;
    String _note;
    String _location;

    protected ExecutionInfoBase(String type, String subtype, Component comp, String note) {
        this._type = type;
        this._subtype = subtype;
        this._comp = comp;
        this._note = note;
        this._location = BinderUtil.hasContext() ? BinderUtil.getContext().getCurrentLocationMessage() : null;
    }

    public Component getComponent() {
        return this._comp;
    }

    public String getType() {
        return this._type;
    }

    public String getNote() {
        return this._note;
    }

    public String getSubtype() {
        return this._subtype;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        ExecutionInfoBase.putEssential(json, "type", this._type);
        if (this._comp != null) {
            ExecutionInfoBase.put(json, "widget", this._comp.getDefinition().getName());
            ExecutionInfoBase.put(json, "uuid", this._comp.getUuid());
            ExecutionInfoBase.put(json, "id", this._comp.getId());
        }
        ExecutionInfoBase.put(json, "subtype", this._subtype);
        ExecutionInfoBase.put(json, "note", ExecutionInfoBase.toString(this._note, 300));
        ExecutionInfoBase.put(json, "location", this._location);
        return json;
    }

    protected static void put(JSONObject json, String prop, Object val) {
        if (val != null) {
            json.put((Object)prop, val);
        }
    }

    protected static void putEssential(JSONObject json, String prop, Object val) {
        json.put((Object)prop, val);
    }

    protected static String toString(Object value, int len) {
        String valstr;
        String string = valstr = value == null ? null : value.toString();
        if (valstr != null && valstr.length() > len) {
            valstr = valstr.substring(0, len - 4) + "...";
        }
        return valstr;
    }
}

