/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.liferay;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.util.logging.Log;
import org.zkoss.zkplus.liferay.JQueryRenderPatch;

public class JQueryRenderCachedPatch
extends JQueryRenderPatch {
    private static final Log log = Log.lookup(JQueryRenderCachedPatch.class);

    protected String getBrowserDelay() {
        return "zk.ie6_ || zk.ie7_ ? 1300 : 100";
    }

    protected String[] processHtml(String html) {
        boolean isAppendCSS = false;
        StringBuffer script = new StringBuffer("<script>function _zkCSS(uri){var e=document.createElement(\"LINK\");e.rel=\"stylesheet\";e.type=\"text/css\";e.href=uri;document.getElementsByTagName(\"HEAD\")[0].appendChild(e);};");
        Pattern cssPattern = Pattern.compile("<link[^>]+href=[\"']?([^'\"> ]+)[\"']?[^>]*(/>|>\\s*</link>)");
        Pattern scriptPattern = Pattern.compile("<script[^>]+src=[\"']?([^'\"> ]+/zk.wpd)[\"']?[^>]*(/>|>\\s*</script>)");
        StringBuffer buffer = new StringBuffer();
        int parseStart = 0;
        int scriptStart = 0;
        int scriptEnd = 0;
        scriptStart = html.indexOf("<script");
        while (scriptStart != -1) {
            isAppendCSS = JQueryRenderCachedPatch.extractCSS(html, parseStart, scriptStart, cssPattern, script, buffer) ? true : isAppendCSS;
            scriptEnd = html.indexOf("</script>", scriptStart);
            if (scriptEnd == -1) break;
            JQueryRenderCachedPatch.removeScript(html, scriptStart, scriptEnd += "</script>".length(), scriptPattern, script, buffer);
            scriptStart = html.indexOf("<script", scriptEnd);
            if (scriptStart != -1) {
                parseStart = scriptEnd;
                continue;
            }
            buffer.append(html.substring(scriptEnd, html.length()));
            break;
        }
        String[] ret = new String[]{"", html};
        if (isAppendCSS) {
            script.append("</script>");
            ret[0] = script.toString();
            ret[1] = buffer.toString();
        }
        return ret;
    }

    private static boolean extractCSS(String html, int start, int end, Pattern cssPattern, StringBuffer scriptBuffer, StringBuffer htmlBuffer) {
        if (start >= end) {
            return false;
        }
        boolean isAppendCSS = false;
        Matcher m = cssPattern.matcher(html.substring(start, end));
        while (m.find()) {
            isAppendCSS = true;
            scriptBuffer.append("_zkCSS('" + m.group(1) + "');");
            m.appendReplacement(htmlBuffer, "");
        }
        m.appendTail(htmlBuffer);
        return isAppendCSS;
    }

    private static void removeScript(String html, int start, int end, Pattern scriptPattern, StringBuffer scriptBuffer, StringBuffer htmlBuffer) {
        String scriptBlock = html.substring(start, end);
        Matcher m = scriptPattern.matcher(scriptBlock);
        if (m.find()) {
            m.appendReplacement(scriptBuffer, "");
        } else {
            htmlBuffer.append(scriptBlock);
        }
    }
}

