/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.CategoryModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCategoryModel
extends AbstractChartModel
implements CategoryModel {
    private static final long serialVersionUID = 20091008183445L;
    private Map<Comparable<?>, Integer> _seriesMap = new HashMap();
    private List<Comparable<?>> _seriesList = new ArrayList();
    private Map<Comparable<?>, Integer> _categoryMap = new HashMap();
    private List<Comparable<?>> _categoryList = new ArrayList();
    private Map<List<Comparable<?>>, Number> _valueMap = new LinkedHashMap();

    @Override
    public Comparable<?> getSeries(int index) {
        return this._seriesList.get(index);
    }

    @Override
    public Comparable<?> getCategory(int index) {
        return this._categoryList.get(index);
    }

    @Override
    public Collection<Comparable<?>> getSeries() {
        return this._seriesList;
    }

    @Override
    public Collection<Comparable<?>> getCategories() {
        return this._categoryList;
    }

    @Override
    public Collection<List<Comparable<?>>> getKeys() {
        return this._valueMap.keySet();
    }

    @Override
    public Number getValue(Comparable<?> series, Comparable<?> category) {
        ArrayList key = new ArrayList(2);
        key.add(series);
        key.add(category);
        Number num = this._valueMap.get(key);
        return num;
    }

    @Override
    public void setValue(Comparable<?> series, Comparable<?> category, Number value) {
        ArrayList key = new ArrayList(2);
        key.add(series);
        key.add(category);
        if (!this._valueMap.containsKey(key)) {
            Integer count;
            if (!this._categoryMap.containsKey(category)) {
                this._categoryMap.put(category, new Integer(1));
                this._categoryList.add(category);
            } else {
                count = this._categoryMap.get(category);
                this._categoryMap.put(category, new Integer(count + 1));
            }
            if (!this._seriesMap.containsKey(series)) {
                this._seriesMap.put(series, new Integer(1));
                this._seriesList.add(series);
            } else {
                count = this._seriesMap.get(series);
                this._seriesMap.put(series, new Integer(count + 1));
            }
        } else {
            Number ovalue = this._valueMap.get(key);
            if (Objects.equals((Object)ovalue, (Object)value)) {
                return;
            }
        }
        this._valueMap.put(key, value);
        this.fireEvent(0, series, category);
    }

    @Override
    public void removeValue(Comparable<?> series, Comparable<?> category) {
        ArrayList key = new ArrayList(2);
        key.add(series);
        key.add(category);
        if (this._valueMap.remove(key) == null) {
            return;
        }
        int ccount = this._categoryMap.get(category);
        if (ccount > 1) {
            this._categoryMap.put(category, new Integer(ccount - 1));
        } else {
            this._categoryMap.remove(category);
            this._categoryList.remove(category);
        }
        int scount = this._seriesMap.get(series);
        if (scount > 1) {
            this._seriesMap.put(series, new Integer(scount - 1));
        } else {
            this._seriesMap.remove(series);
            this._seriesList.remove(series);
        }
        this.fireEvent(2, series, category);
    }

    @Override
    public void clear() {
        this._seriesMap.clear();
        this._seriesList.clear();
        this._categoryMap.clear();
        this._categoryList.clear();
        this._valueMap.clear();
        this.fireEvent(2, null, null);
    }

    @Override
    public Object clone() {
        SimpleCategoryModel clone = (SimpleCategoryModel)super.clone();
        if (this._seriesMap != null) {
            clone._seriesMap = new HashMap(this._seriesMap);
        }
        if (this._seriesList != null) {
            clone._seriesList = new ArrayList(this._seriesList);
        }
        if (this._categoryMap != null) {
            clone._categoryMap = new HashMap(this._categoryMap);
        }
        if (this._categoryList != null) {
            clone._categoryList = new ArrayList(this._categoryList);
        }
        if (this._valueMap != null) {
            clone._valueMap = new LinkedHashMap(this._valueMap);
        }
        return clone;
    }
}

