

zul.wgt.Groupbox = zk.$extends(zul.Widget, {
	_open: true,
	_closable: true,

	$define: { 
		
		
		open: function (open, fromServer) {
			var node = this.$n();
			if (node && this._closable) {
				if (open && this._isDefault())
						jq(node).removeClass(this.getZclass() + "-colpsd");
				zk(this.getCaveNode())[open?'slideDown':'slideUp'](this);
				if (!fromServer) this.fire('onOpen', {open:open});
			}
		},
		
		
		closable: _zkf = function () {
			this._updDomOuter();
		},
		
		
		contentStyle: _zkf,
		
		
		contentSclass: _zkf,
		
		
		title: _zkf
	},
	_isDefault: function () {
		return this._mold == 'default';
	},
	_updDomOuter: function () {
		this.rerender(zk.Skipper.nonCaptionSkipper);
	},
	_contentAttrs: function () {
		var html = ' class="', s = this._contentSclass,
			cap = this.caption,
			title = this.getTitle(),
			zcls = this.getZclass();
		if (s)
			html += s + ' ';
		html += zcls + '-cnt';
		if (!title && !cap)
			html += ' '+ zcls + '-notitle';
		html += '"';

		s = this._contentStyle;
		if (cap || title) 
			s = 'border-top:0;' + (s||'');
		if (!this._open)
			s = 'display:none;' + (s||'');
		if (s)
			html += ' style="' + s + '"';
		return html;
	},
	_redrawCave: function (out, skipper) { 
		out.push('<div id="', this.uuid, '-cave"', this._contentAttrs(), '>');
	
		if (!skipper)
			for (var w = this.firstChild, cap = this.caption; w; w = w.nextSibling)
				if (w != cap)
					w.redraw(out);

		out.push('</div>');
	},

	setHeight: function () {
		this.$supers('setHeight', arguments);
		if (this.desktop) this._fixHgh();
	},
	_fixHgh: function () {
		var hgh = this.$n().style.height;
		if (hgh && hgh != "auto" && this.isOpen()) {
			var n;
			if (n = this.$n('cave')) {
				if (zk.ie6_) n.style.height = "";
				var wgt = this,
					$n = zk(n),
					fix = function() {
					
					
					var fixh = 0;
					if (zk.ie6_ && wgt._isDefault() && (wgt.caption || wgt._title)) {
						fixh += 1;
					}

					
					n.style.height = $n.revisedHeight($n.vflexHeight(), true) + fixh + "px";
				};
				fix();
				if (zk.gecko) setTimeout(fix, 0);
					
					
			}
		}
	},
	getParentSize_: zk.ie6_ ? function (p) {
		var zkp = zk(p),
			hgh,
			wdh,
			s = p.style;
		if (s.width.indexOf('px') >= 0) {
			wdh = zk.parseInt(s.width);
		} else {
			
			var n = this.$n(),
				oldVal = n.style.display;
			n.style.display = 'none';
			wdh = zkp.revisedWidth(p.offsetWidth);
			n.style.display = oldVal;
		}
		if (s.height.indexOf('px') >= 0) {
			hgh = zk.parseInt(s.height);
		}
		return {height: hgh || zkp.revisedHeight(p.offsetHeight),
					width: wdh || zkp.revisedWidth(p.offsetWidth)};
	} : function(p) {
		return this.$supers('getParentSize_', arguments);
	},
	
	setFlexSizeH_: function(n, zkn, height, isFlexMin) {
		var h = 0, 
			margins = zkn.sumStyles("tb", jq.margins);
		if (isFlexMin && (this.caption || this._title)) {
			
			var node = this.$n(),
				c;
			for (c = n.firstChild; c; c = c.nextSibling)
				h += jq(c).outerHeight();
		} else
			h = zkn.revisedHeight(height, true); 
		n.style.height = jq.px0(h);
			
		
		if (zk.safari) {
			margins -= zkn.sumStyles("tb", jq.margins);
			if (margins) 
				n.style.height = jq.px0(h + margins);
		}
	},
	
	onSize: function () {
		this._fixHgh();
		
		
		
	},
	updateDomStyle_: function () {
		this.$supers('updateDomStyle_', arguments);
		if (this.desktop) this.onSize();
	},

	
	focus_: function (timeout) {
		var cap = this.caption;
		for (var w = this.firstChild; w; w = w.nextSibling)
			if (w != cap && w.focus_(timeout))
				return true;
		return cap && cap.focus_(timeout);
	},
	getZclass: function () {
		var zcls = this._zclass;
		return zcls ? zcls: this._isDefault() ? "z-groupbox": "z-groupbox-3d";
	},
	bind_: function () {
		this.$supers(zul.wgt.Groupbox, 'bind_', arguments);
		zWatch.listen({onSize: this});
		var tt;
		if (this.getTitle() && (tt = this.$n('title')))
			this.domListen_(tt, 'onClick', '_doTitleClick');
	},
	unbind_: function () {
		zWatch.unlisten({onSize: this});
		var tt;
		if (tt = this.$n('title'))
			this.domUnlisten_(tt, 'onClick', '_doTitleClick');
		this.$supers(zul.wgt.Groupbox, 'unbind_', arguments);
	},
	
	_doTitleClick: function () {
		this.setOpen(!this.isOpen());
		this.$supers('doClick_', arguments);
	},
	onChildAdded_: function (child) {
		this.$supers('onChildAdded_', arguments);
		if (child.$instanceof(zul.wgt.Caption)) {
			this.caption = child;
			this.rerender();
		}
	},
	onChildRemoved_: function (child) {
		this.$supers('onChildRemoved_', arguments);
		if (child == this.caption) {
			this.caption = null;
			this.rerender();
		}
	},
	
	getChildMinSize_: function (attr, wgt) {
		if (!wgt.$instanceof(zul.wgt.Caption))
			return this.$supers('getChildMinSize_', arguments);
	},

	domClass_: function () {
		var html = this.$supers('domClass_', arguments);
		if (!this._open) {
			if (html) html += ' ';
			html += this.getZclass() + '-colpsd';
		}
		return html;
	},
	afterAnima_: function (visible) {
		if (!visible && this._isDefault())
			jq(this.$n()).addClass(this.getZclass() + "-colpsd");
		this.$supers('afterAnima_', arguments);
	}
});
