/*
 * Decompiled with CFR 0.152.
 */
package junitparams.custom;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junitparams.FileParameters;
import junitparams.custom.ParametersProvider;
import junitparams.mappers.DataMapper;
import org.junit.runners.model.FrameworkMethod;

public class FileParametersProvider
implements ParametersProvider<FileParameters> {
    private FileParameters fileParameters;

    @Override
    public void initialize(FileParameters fileParameters, FrameworkMethod frameworkMethod) {
        this.fileParameters = fileParameters;
    }

    @Override
    public Object[] getParameters() {
        return this.paramsFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] paramsFromFile() {
        Object[] objectArray;
        Reader reader = this.createProperReader();
        DataMapper mapper = this.fileParameters.mapper().newInstance();
        try {
            objectArray = mapper.map(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not successfully read parameters from file: " + this.fileParameters.value(), e);
            }
        }
        reader.close();
        return objectArray;
    }

    private Reader createProperReader() throws IOException {
        String filepath = this.fileParameters.value();
        String encoding = this.fileParameters.encoding();
        if (filepath.indexOf(58) < 0) {
            return new FileReader(filepath);
        }
        String protocol = filepath.substring(0, filepath.indexOf(58));
        String filename = filepath.substring(filepath.indexOf(58) + 1);
        if ("classpath".equals(protocol)) {
            return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(filename), encoding);
        }
        if ("file".equals(protocol)) {
            return new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        }
        throw new IllegalArgumentException("Unknown file access protocol. Only 'file' and 'classpath' are supported!");
    }
}

