/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

@ChannelHandler.Sharable
class RequestAndResponseHandler
extends ChannelDuplexHandler {
    private final MonitoringModule monitoringModule;

    RequestAndResponseHandler(MonitoringModule monitoringModule) {
        this.monitoringModule = monitoringModule;
    }

    public void write(ChannelHandlerContext ctx, Object object, ChannelPromise promise) throws Exception {
        if (object instanceof FullHttpRequest) {
            int payloadSize = ((FullHttpRequest)object).content().readableBytes();
            this.monitoringModule.incrementSentHttpRequests(payloadSize);
        }
        super.write(ctx, object, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object object) {
        FullHttpResponse msg = (FullHttpResponse)object;
        this.monitoringModule.incrementHttpResponses();
        if (msg.status().codeClass() != HttpStatusClass.SUCCESS) {
            System.out.println(msg.content().toString(Charset.defaultCharset()));
            this.monitoringModule.incrementHttpErrors(msg.status().code(), msg.content().toString(Charset.defaultCharset()));
        }
        if (!HttpUtil.isKeepAlive((HttpMessage)msg)) {
            ctx.close();
        }
        ReferenceCountUtil.release((Object)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.monitoringModule.addPipelineError(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.monitoringModule.incrementChannelInactive();
    }
}

