/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.utils;

import java.util.Arrays;
import pl.tkowalcz.tjahzi.utils.Objects;

public class TextBuilder
implements Appendable,
CharSequence {
    private static final int INITIAL_SIZE = 8;
    private static final int CAPACITY_INCREMENT = 64;
    private char[] chars = new char[8];
    private int length;

    public TextBuilder clear() {
        this.length = 0;
        return this;
    }

    @Override
    public TextBuilder append(CharSequence string) {
        this.ensureCapacity(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.chars[this.length++] = string.charAt(i);
        }
        return this;
    }

    @Override
    public TextBuilder append(CharSequence sequence, int start, int end) {
        Objects.checkFromToIndex(start, end, sequence.length());
        this.ensureCapacity(sequence.length());
        for (int i = start; i < end; ++i) {
            this.chars[this.length++] = sequence.charAt(i);
        }
        return this;
    }

    @Override
    public TextBuilder append(char c) {
        this.ensureCapacity(1);
        this.chars[this.length++] = c;
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        Objects.checkIndex(index, this.length);
        return this.chars[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        Objects.checkFromToIndex(start, end, this.length);
        return new String(this.chars, start, end - start);
    }

    public TextBuilder setCharAt(int index, char c) {
        Objects.checkIndex(index, this.length);
        this.chars[index] = c;
        return this;
    }

    @Override
    public String toString() {
        return new String(this.chars, 0, this.length);
    }

    private void ensureCapacity(int requiredCapacity) {
        if (this.length + requiredCapacity >= this.chars.length) {
            int missingCapacity = this.length + requiredCapacity - this.chars.length;
            int expandedSize = this.chars.length + Math.max(64, missingCapacity);
            this.chars = Arrays.copyOf(this.chars, expandedSize);
        }
    }
}

