/*
 * Decompiled with CFR 0.152.
 */
package pl.tlinkowski.unij.service.collect.jdk8;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.NonNull;
import pl.tlinkowski.unij.service.api.UniJService;
import pl.tlinkowski.unij.service.api.collect.UnmodifiableSetFactory;

@UniJService(priority=40)
public final class Jdk8UnmodifiableSetFactory
implements UnmodifiableSetFactory {
    private static final Set<Object> EMPTY_SET = new Builder(0).build();

    public <E> Collector<E, ?, Set<E>> collector() {
        return Collectors.collectingAndThen(Collectors.toSet(), this::ofTrustedHashSet);
    }

    public <E> Set<E> copyOf(Collection<? extends E> coll) {
        return this.ofTrustedHashSet(new HashSet<E>(coll));
    }

    public <E> Set<E> of() {
        return EMPTY_SET;
    }

    public <E> Set<E> of(@NonNull E e1) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        return Collections.singleton(e1);
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        return new Builder<E>(2).add(e1).add(e2).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        return new Builder<E>(3).add(e1).add(e2).add(e3).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        return new Builder<E>(4).add(e1).add(e2).add(e3).add(e4).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4, @NonNull E e5) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        if (e5 == null) {
            throw new NullPointerException("e5 is marked non-null but is null");
        }
        return new Builder<E>(5).add(e1).add(e2).add(e3).add(e4).add(e5).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4, @NonNull E e5, @NonNull E e6) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        if (e5 == null) {
            throw new NullPointerException("e5 is marked non-null but is null");
        }
        if (e6 == null) {
            throw new NullPointerException("e6 is marked non-null but is null");
        }
        return new Builder<E>(6).add(e1).add(e2).add(e3).add(e4).add(e5).add(e6).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4, @NonNull E e5, @NonNull E e6, @NonNull E e7) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        if (e5 == null) {
            throw new NullPointerException("e5 is marked non-null but is null");
        }
        if (e6 == null) {
            throw new NullPointerException("e6 is marked non-null but is null");
        }
        if (e7 == null) {
            throw new NullPointerException("e7 is marked non-null but is null");
        }
        return new Builder<E>(7).add(e1).add(e2).add(e3).add(e4).add(e5).add(e6).add(e7).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4, @NonNull E e5, @NonNull E e6, @NonNull E e7, @NonNull E e8) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        if (e5 == null) {
            throw new NullPointerException("e5 is marked non-null but is null");
        }
        if (e6 == null) {
            throw new NullPointerException("e6 is marked non-null but is null");
        }
        if (e7 == null) {
            throw new NullPointerException("e7 is marked non-null but is null");
        }
        if (e8 == null) {
            throw new NullPointerException("e8 is marked non-null but is null");
        }
        return new Builder<E>(8).add(e1).add(e2).add(e3).add(e4).add(e5).add(e6).add(e7).add(e8).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4, @NonNull E e5, @NonNull E e6, @NonNull E e7, @NonNull E e8, @NonNull E e9) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        if (e5 == null) {
            throw new NullPointerException("e5 is marked non-null but is null");
        }
        if (e6 == null) {
            throw new NullPointerException("e6 is marked non-null but is null");
        }
        if (e7 == null) {
            throw new NullPointerException("e7 is marked non-null but is null");
        }
        if (e8 == null) {
            throw new NullPointerException("e8 is marked non-null but is null");
        }
        if (e9 == null) {
            throw new NullPointerException("e9 is marked non-null but is null");
        }
        return new Builder<E>(9).add(e1).add(e2).add(e3).add(e4).add(e5).add(e6).add(e7).add(e8).add(e9).build();
    }

    public <E> Set<E> of(@NonNull E e1, @NonNull E e2, @NonNull E e3, @NonNull E e4, @NonNull E e5, @NonNull E e6, @NonNull E e7, @NonNull E e8, @NonNull E e9, @NonNull E e10) {
        if (e1 == null) {
            throw new NullPointerException("e1 is marked non-null but is null");
        }
        if (e2 == null) {
            throw new NullPointerException("e2 is marked non-null but is null");
        }
        if (e3 == null) {
            throw new NullPointerException("e3 is marked non-null but is null");
        }
        if (e4 == null) {
            throw new NullPointerException("e4 is marked non-null but is null");
        }
        if (e5 == null) {
            throw new NullPointerException("e5 is marked non-null but is null");
        }
        if (e6 == null) {
            throw new NullPointerException("e6 is marked non-null but is null");
        }
        if (e7 == null) {
            throw new NullPointerException("e7 is marked non-null but is null");
        }
        if (e8 == null) {
            throw new NullPointerException("e8 is marked non-null but is null");
        }
        if (e9 == null) {
            throw new NullPointerException("e9 is marked non-null but is null");
        }
        if (e10 == null) {
            throw new NullPointerException("e10 is marked non-null but is null");
        }
        return new Builder<E>(10).add(e1).add(e2).add(e3).add(e4).add(e5).add(e6).add(e7).add(e8).add(e9).add(e10).build();
    }

    @SafeVarargs
    public final <E> Set<E> of(E ... elements) {
        switch (elements.length) {
            case 0: {
                return this.of();
            }
            case 1: {
                return this.of(elements[0]);
            }
        }
        return this.ofAtLeastTwoElements(elements);
    }

    private <E> Set<E> ofTrustedHashSet(Set<E> set) {
        switch (set.size()) {
            case 0: {
                return this.of();
            }
            case 1: {
                return this.of(set.iterator().next());
            }
        }
        set.forEach(Objects::requireNonNull);
        return Collections.unmodifiableSet((HashSet)set);
    }

    private <E> Set<E> ofAtLeastTwoElements(E[] elements) {
        Builder<E> builder = new Builder<E>(elements.length);
        for (E element : elements) {
            builder.add(Objects.requireNonNull(element));
        }
        return builder.build();
    }

    private static class Builder<E> {
        private final Set<E> set;

        Builder(int size) {
            this.set = new HashSet((int)((double)size / 0.75));
        }

        Builder<E> add(E element) {
            if (!this.set.add(element)) {
                throw new IllegalArgumentException("Duplicate element: " + element);
            }
            return this;
        }

        Set<E> build() {
            return Collections.unmodifiableSet(this.set);
        }
    }
}

