/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.csc.ClientSideCacheable;
import redis.clients.jedis.csc.DefaultClientSideCacheable;
import redis.clients.jedis.csc.hash.CommandLongHasher;
import redis.clients.jedis.util.SafeEncoder;

@Experimental
public abstract class ClientSideCache {
    protected static final int DEFAULT_MAXIMUM_SIZE = 10000;
    protected static final int DEFAULT_EXPIRE_SECONDS = 100;
    private final Map<ByteBuffer, Set<Long>> keyToCommandHashes = new ConcurrentHashMap<ByteBuffer, Set<Long>>();
    private final CommandLongHasher commandHasher;
    private final ClientSideCacheable cacheable;

    protected ClientSideCache(CommandLongHasher commandHasher) {
        this(commandHasher, DefaultClientSideCacheable.INSTANCE);
    }

    protected ClientSideCache(CommandLongHasher commandHasher, ClientSideCacheable cacheable) {
        this.commandHasher = commandHasher;
        this.cacheable = cacheable;
    }

    protected abstract void invalidateAllHashes();

    protected abstract void invalidateHashes(Iterable<Long> var1);

    protected abstract void putValue(long var1, Object var3);

    protected abstract Object getValue(long var1);

    public final void clear() {
        this.invalidateAllKeysAndCommandHashes();
    }

    public final void removeKey(Object key) {
        this.invalidateKeyAndRespectiveCommandHashes(key);
    }

    public final void invalidate(List list) {
        if (list == null) {
            this.invalidateAllKeysAndCommandHashes();
            return;
        }
        list.forEach(this::invalidateKeyAndRespectiveCommandHashes);
    }

    private void invalidateAllKeysAndCommandHashes() {
        this.invalidateAllHashes();
        this.keyToCommandHashes.clear();
    }

    private void invalidateKeyAndRespectiveCommandHashes(Object key) {
        ByteBuffer mapKey = this.makeKeyForKeyToCommandHashes(key);
        Set<Long> hashes = this.keyToCommandHashes.get(mapKey);
        if (hashes != null) {
            this.invalidateHashes(hashes);
            this.keyToCommandHashes.remove(mapKey);
        }
    }

    public final <T> T get(Function<CommandObject<T>, T> loader, CommandObject<T> command, Object ... keys) {
        if (!this.cacheable.isCacheable(command.getArguments().getCommand(), keys)) {
            return loader.apply(command);
        }
        long hash = this.commandHasher.hash(command);
        Object value = this.getValue(hash);
        if (value != null) {
            return (T)value;
        }
        value = loader.apply(command);
        if (value != null) {
            this.putValue(hash, value);
            for (Object key : keys) {
                ByteBuffer mapKey = this.makeKeyForKeyToCommandHashes(key);
                if (this.keyToCommandHashes.containsKey(mapKey)) {
                    this.keyToCommandHashes.get(mapKey).add(hash);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(hash);
                this.keyToCommandHashes.put(mapKey, set);
            }
        }
        return (T)value;
    }

    private ByteBuffer makeKeyForKeyToCommandHashes(Object key) {
        if (key instanceof byte[]) {
            return ClientSideCache.makeKeyForKeyToCommandHashes((byte[])key);
        }
        if (key instanceof String) {
            return ClientSideCache.makeKeyForKeyToCommandHashes(SafeEncoder.encode((String)key));
        }
        throw new IllegalArgumentException("" + key.getClass().getSimpleName() + " is not supported. Value: " + String.valueOf(key));
    }

    private static ByteBuffer makeKeyForKeyToCommandHashes(byte[] b) {
        return ByteBuffer.wrap(b);
    }
}

