/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.base.types;

import com.sun.syndication.feed.module.base.types.CloneableType;
import com.sun.syndication.feed.module.base.types.FloatUnit;
import java.util.HashMap;

public class ShippingType
implements CloneableType {
    private FloatUnit price;
    private ServiceEnumeration service;
    private String country;

    public ShippingType(FloatUnit price, ServiceEnumeration service, String country) {
        this.price = price;
        this.service = service;
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public FloatUnit getPrice() {
        return this.price;
    }

    public ServiceEnumeration getService() {
        return this.service;
    }

    public Object clone() {
        return new ShippingType(this.price, this.service, this.country);
    }

    public String toString() {
        return this.country + " " + this.price + " " + this.service;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ShippingType)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public static class ServiceEnumeration {
        private static final HashMap lookup = new HashMap();
        public static final ServiceEnumeration STANDARD = new ServiceEnumeration("Standard");
        public static final ServiceEnumeration FREIGHT = new ServiceEnumeration("Freight");
        public static final ServiceEnumeration OVERNIGHT = new ServiceEnumeration("Overnight");
        private String value;

        private ServiceEnumeration(String value) {
            this.value = value;
            lookup.put(this.value.toUpperCase(), this);
        }

        public String getValue() {
            return this.value;
        }

        public static ServiceEnumeration findByValue(String value) {
            return (ServiceEnumeration)lookup.get(value.toUpperCase());
        }

        public String toString() {
            return this.value;
        }
    }
}

