/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.photocast.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.photocast.PhotocastModule;
import com.sun.syndication.feed.module.photocast.io.Parser;
import com.sun.syndication.io.ModuleGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class Generator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"apple-wallpapers", (String)"http://www.apple.com/ilife/wallpapers");
    private static final HashSet NAMESPACES = new HashSet();
    private static final String FEED_VERSION = "0.9";

    public void generate(Module module, Element element) {
        if (!(module instanceof PhotocastModule)) {
            return;
        }
        PhotocastModule pm = (PhotocastModule)module;
        if (element.getName().equals("channel") || element.getName().equals("feed")) {
            element.addContent((Content)this.generateSimpleElement("feedVersion", FEED_VERSION));
            return;
        }
        element.addContent((Content)this.generateSimpleElement("photoDate", Parser.PHOTO_DATE_FORMAT.format(pm.getPhotoDate())));
        element.addContent((Content)this.generateSimpleElement("cropDate", Parser.CROP_DATE_FORMAT.format(pm.getCropDate())));
        element.addContent((Content)this.generateSimpleElement("thumbnail", pm.getThumbnailUrl().toString()));
        element.addContent((Content)this.generateSimpleElement("image", pm.getImageUrl().toString()));
        Element e = new Element("metadata", NS);
        Element pd = new Element("PhotoDate", "");
        pd.addContent(pm.getMetadata().getPhotoDate().toString());
        e.addContent((Content)pd);
        Element com = new Element("Comments", "");
        com.addContent(pm.getMetadata().getComments());
        e.addContent((Content)com);
        element.addContent((Content)e);
    }

    public Set getNamespaces() {
        return NAMESPACES;
    }

    public String getNamespaceUri() {
        return "http://www.apple.com/ilife/wallpapers";
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(NS);
    }
}

