/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.element;

import java.io.File;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class FileInput
extends TypifiedElement {
    public FileInput(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public void setFileToUpload(String fileName) {
        WebElement fileInputElement = this.getNotProxiedInputElement();
        if (HtmlElementUtils.isOnRemoteWebDriver(fileInputElement)) {
            this.setLocalFileDetector((RemoteWebElement)fileInputElement);
        }
        String filePath = this.getFilePath(fileName);
        fileInputElement.sendKeys(new CharSequence[]{filePath});
    }

    public void submit() {
        this.getWrappedElement().submit();
    }

    private WebElement getNotProxiedInputElement() {
        return this.getWrappedElement().findElement(By.xpath((String)"."));
    }

    private void setLocalFileDetector(RemoteWebElement element) {
        element.setFileDetector((FileDetector)new LocalFileDetector());
    }

    private String getFilePath(String fileName) {
        if (HtmlElementUtils.existsInClasspath(fileName)) {
            return this.getPathForResource(fileName);
        }
        return this.getPathForSystemFile(fileName);
    }

    private String getPathForResource(String fileName) {
        return HtmlElementUtils.getResourceFromClasspath(fileName).getPath();
    }

    private String getPathForSystemFile(String fileName) {
        File file = new File(fileName);
        return file.getPath();
    }
}

