/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader;

import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementDecorator;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementFactory;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementLocatorFactory;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementLoader {
    public static <T> T create(Class<T> clazz, WebDriver driver) {
        if (HtmlElementUtils.isHtmlElement(clazz)) {
            return HtmlElementLoader.createHtmlElement(clazz, (SearchContext)driver);
        }
        return HtmlElementLoader.createPageObject(clazz, driver);
    }

    public static <T> void populate(T instance, WebDriver driver) {
        if (HtmlElementUtils.isHtmlElement(instance)) {
            HtmlElement htmlElement = (HtmlElement)instance;
            HtmlElementLoader.populateHtmlElement(htmlElement, (SearchContext)driver);
        } else {
            HtmlElementLoader.populatePageObject(instance, driver);
        }
    }

    public static <T extends HtmlElement> T createHtmlElement(Class<T> clazz, SearchContext searchContext) {
        T htmlElementInstance = HtmlElementFactory.createHtmlElementInstance(clazz);
        HtmlElementLoader.populateHtmlElement(htmlElementInstance, new HtmlElementLocatorFactory(searchContext));
        return htmlElementInstance;
    }

    public static <T> T createPageObject(Class<T> clazz, WebDriver driver) {
        T page = HtmlElementFactory.createPageObjectInstance(clazz, driver);
        HtmlElementLoader.populatePageObject(page, new HtmlElementLocatorFactory((SearchContext)driver));
        return page;
    }

    public static void populateHtmlElement(HtmlElement htmlElement, SearchContext searchContext) {
        HtmlElementLoader.populateHtmlElement(htmlElement, new HtmlElementLocatorFactory(searchContext));
    }

    public static void populateHtmlElement(HtmlElement htmlElement, CustomElementLocatorFactory locatorFactory) {
        Class<?> htmlElementClass = htmlElement.getClass();
        ElementLocator locator = locatorFactory.createLocator(htmlElementClass);
        ClassLoader htmlElementClassLoader = htmlElement.getClass().getClassLoader();
        String elementName = HtmlElementUtils.getElementName(htmlElementClass);
        WebElement elementToWrap = HtmlElementFactory.createNamedProxyForWebElement(htmlElementClassLoader, locator, elementName);
        htmlElement.setWrappedElement(elementToWrap);
        htmlElement.setName(elementName);
        PageFactory.initElements((FieldDecorator)new HtmlElementDecorator((SearchContext)elementToWrap), (Object)htmlElement);
    }

    public static void populatePageObject(Object page, WebDriver driver) {
        HtmlElementLoader.populatePageObject(page, new HtmlElementLocatorFactory((SearchContext)driver));
    }

    public static void populatePageObject(Object page, CustomElementLocatorFactory locatorFactory) {
        PageFactory.initElements((FieldDecorator)new HtmlElementDecorator(locatorFactory), (Object)page);
    }
}

