/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import ru.yandex.qatools.htmlelements.annotations.Block;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;
import ru.yandex.qatools.htmlelements.pagefactory.DefaultFieldAnnotationsHandler;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementFieldAnnotationsHandler
extends DefaultFieldAnnotationsHandler {
    public HtmlElementFieldAnnotationsHandler(Field field) {
        super(field);
    }

    @Override
    public By buildBy() {
        if (HtmlElementUtils.isHtmlElement(this.getField())) {
            return this.buildByFromHtmlElementAnnotations();
        }
        if (HtmlElementUtils.isHtmlElementList(this.getField())) {
            return this.buildByFromHtmlElementListAnnotations();
        }
        return this.buildByFromDefaultAnnotations();
    }

    private By buildByFromFindAnnotations() {
        if (this.getField().isAnnotationPresent(FindBys.class)) {
            FindBys findBys = this.getField().getAnnotation(FindBys.class);
            return this.buildByFromFindBys(findBys);
        }
        if (this.getField().isAnnotationPresent(FindAll.class)) {
            FindAll findBys = this.getField().getAnnotation(FindAll.class);
            return this.buildBysFromFindAll(findBys);
        }
        if (this.getField().isAnnotationPresent(FindBy.class)) {
            FindBy findBy = this.getField().getAnnotation(FindBy.class);
            return this.buildByFromFindBy(findBy);
        }
        return null;
    }

    private By buildByFromHtmlElementAnnotations() {
        this.assertValidAnnotations();
        By result = this.buildByFromFindAnnotations();
        if (result != null) {
            return result;
        }
        for (Class<?> fieldClass = this.getField().getType(); fieldClass != Object.class; fieldClass = fieldClass.getSuperclass()) {
            if (fieldClass.isAnnotationPresent(Block.class)) {
                Block block = fieldClass.getAnnotation(Block.class);
                FindBy findBy = block.value();
                return this.buildByFromFindBy(findBy);
            }
            if (!fieldClass.isAnnotationPresent(FindBy.class)) continue;
            return this.buildByFromFindBy(fieldClass.getAnnotation(FindBy.class));
        }
        return this.buildByFromDefault();
    }

    private By buildByFromHtmlElementListAnnotations() {
        this.assertValidAnnotations();
        By result = this.buildByFromFindAnnotations();
        if (result != null) {
            return result;
        }
        for (Class listParameterClass = HtmlElementUtils.getGenericParameterClass(this.getField()); listParameterClass != Object.class; listParameterClass = listParameterClass.getSuperclass()) {
            if (listParameterClass.isAnnotationPresent(Block.class)) {
                Block block = listParameterClass.getAnnotation(Block.class);
                FindBy findBy = block.value();
                return this.buildByFromFindBy(findBy);
            }
            if (!listParameterClass.isAnnotationPresent(FindBy.class)) continue;
            return this.buildByFromFindBy(listParameterClass.getAnnotation(FindBy.class));
        }
        throw new HtmlElementsException(String.format("Cannot determine how to locate element %s", this.getField()));
    }

    private By buildByFromDefaultAnnotations() {
        return super.buildBy();
    }
}

