/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementDecorator;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementFactory;

public class HtmlElementListNamedProxyHandler<T extends HtmlElement>
implements InvocationHandler {
    private final Class<T> htmlElementClass;
    private final ElementLocator locator;
    private final String name;

    public HtmlElementListNamedProxyHandler(Class<T> htmlElementClass, ElementLocator locator, String name) {
        this.htmlElementClass = htmlElementClass;
        this.locator = locator;
        this.name = name;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if ("toString".equals(method.getName())) {
            return this.name;
        }
        LinkedList<T> htmlElements = new LinkedList<T>();
        List elements = this.locator.findElements();
        int elementNumber = 0;
        for (WebElement element : elements) {
            T htmlElement = HtmlElementFactory.createHtmlElementInstance(this.htmlElementClass);
            ((HtmlElement)htmlElement).setWrappedElement(element);
            String htmlElementName = String.format("%s [%d]", this.name, elementNumber);
            ((HtmlElement)htmlElement).setName(htmlElementName);
            PageFactory.initElements((FieldDecorator)new HtmlElementDecorator((SearchContext)element), htmlElement);
            htmlElements.add(htmlElement);
            ++elementNumber;
        }
        try {
            return method.invoke(htmlElements, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

