/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.pagefactory;

import java.util.HashSet;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.How;
import org.openqa.selenium.support.pagefactory.ByAll;
import org.openqa.selenium.support.pagefactory.ByChained;

public abstract class AnnotationsHandler {
    public abstract By buildBy();

    public abstract boolean shouldCache();

    protected By buildByFromFindBys(FindBys findBys) {
        this.assertValidFindBys(findBys);
        FindBy[] findByArray = findBys.value();
        By[] byArray = new By[findByArray.length];
        for (int i = 0; i < findByArray.length; ++i) {
            byArray[i] = this.buildByFromFindBy(findByArray[i]);
        }
        return new ByChained(byArray);
    }

    protected By buildByFromFindBy(FindBy findBy) {
        this.assertValidFindBy(findBy);
        By ans = this.buildByFromShortFindBy(findBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(findBy);
        }
        return ans;
    }

    protected By buildByFromLongFindBy(FindBy findBy) {
        How how = findBy.how();
        String using = findBy.using();
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element");
    }

    protected By buildByFromShortFindBy(FindBy findBy) {
        if (!"".equals(findBy.className())) {
            return By.className((String)findBy.className());
        }
        if (!"".equals(findBy.css())) {
            return By.cssSelector((String)findBy.css());
        }
        if (!"".equals(findBy.id())) {
            return By.id((String)findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            return By.linkText((String)findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            return By.name((String)findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            return By.partialLinkText((String)findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            return By.tagName((String)findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            return By.xpath((String)findBy.xpath());
        }
        return null;
    }

    private void assertValidFindBys(FindBys findBys) {
        for (FindBy findBy : findBys.value()) {
            this.assertValidFindBy(findBy);
        }
    }

    protected By buildBysFromFindAll(FindAll findAll) {
        this.assertValidFindAll(findAll);
        FindBy[] findByArray = findAll.value();
        By[] byArray = new By[findByArray.length];
        for (int i = 0; i < findByArray.length; ++i) {
            byArray[i] = this.buildByFromFindBy(findByArray[i]);
        }
        return new ByAll(byArray);
    }

    private void assertValidFindBy(FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<String> finders = new HashSet<String>();
        if (!"".equals(findBy.using())) {
            finders.add("how: " + findBy.using());
        }
        if (!"".equals(findBy.className())) {
            finders.add("class name:" + findBy.className());
        }
        if (!"".equals(findBy.css())) {
            finders.add("css:" + findBy.css());
        }
        if (!"".equals(findBy.id())) {
            finders.add("id: " + findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            finders.add("link text: " + findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            finders.add("name: " + findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add("partial link text: " + findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            finders.add("tag name: " + findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            finders.add("xpath: " + findBy.xpath());
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
    }

    private void assertValidFindAll(FindAll findAll) {
        for (FindBy findBy : findAll.value()) {
            this.assertValidFindBy(findBy);
        }
    }
}

