/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.jira;

import java.util.Map;
import java.util.Optional;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClient;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;
import se.bjurr.gitchangelog.internal.integrations.rest.RestClient;

public class DefaultJiraClient
extends JiraClient {
    private RestClient client = new RestClient();

    public DefaultJiraClient(String api) {
        super(api);
    }

    @Override
    public JiraClient withBasicCredentials(String username, String password) {
        this.client = this.client.withBasicAuthCredentials(username, password);
        return this;
    }

    @Override
    public JiraClient withBearer(String bearerToken) {
        this.client = this.client.withBearer(bearerToken);
        return this;
    }

    @Override
    public JiraClient withTokenCredentials(String token) {
        this.client = this.client.withTokenAuthCredentials(token);
        return this;
    }

    @Override
    public JiraClient withHeaders(Map<String, String> headers) {
        this.client = this.client.withHeaders(headers);
        return this;
    }

    @Override
    public Optional<JiraIssue> getIssue(String issue) throws GitChangelogIntegrationException {
        String endpoint = this.getEndpoint(issue);
        Optional<String> json = this.client.get(endpoint);
        if (json.isPresent()) {
            String jsonString = json.get();
            try {
                JiraIssue jiraIssue = this.toJiraIssue(issue, jsonString);
                return Optional.of(jiraIssue);
            }
            catch (Exception e) {
                throw new GitChangelogIntegrationException("Unable to parse:\n" + jsonString, e);
            }
        }
        return Optional.empty();
    }
}

