/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.model.DebloatedDependency;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;

public abstract class AbstractDebloater<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDebloater.class);
    protected final ProjectDependencyAnalysis analysis;

    public void write() throws IOException {
        log.info("Starting debloating POM file...");
        this.logChanges();
        this.setDependencies(this.analysis.getUsedDependencies().stream().map(this::toProviderDependency).collect(Collectors.toList()));
        this.logDependencies();
        this.postProcessDependencies();
        this.writeFile();
    }

    protected abstract T toProviderDependency(DebloatedDependency var1);

    protected abstract void setDependencies(List<T> var1);

    protected abstract void writeFile() throws IOException;

    protected abstract void logDependencies();

    protected abstract void postProcessDependencies();

    private void logChanges() {
        if (this.analysis.hasUsedTransitiveDependencies()) {
            int nbUsedTransitiveDeps = this.analysis.getUsedTransitiveDependencies().size();
            log.info("Adding {} used transitive {} as direct {}.", new Object[]{nbUsedTransitiveDeps, this.getDependencyWording(nbUsedTransitiveDeps), this.getDependencyWording(nbUsedTransitiveDeps)});
        }
        if (this.analysis.hasUnusedDirectDependencies()) {
            int nbUnusedDirectDeps = this.analysis.getUnusedDirectDependencies().size();
            log.info("Removing {} unused direct {}.", (Object)nbUnusedDirectDeps, (Object)this.getDependencyWording(nbUnusedDirectDeps));
        }
        if (this.analysis.hasUnusedTransitiveDependencies()) {
            int nbUnusedTransitiveDeps = this.analysis.getUnusedTransitiveDependencies().size();
            log.info("Excluding {} unused transitive {} one-by-one.", (Object)nbUnusedTransitiveDeps, (Object)this.getDependencyWording(nbUnusedTransitiveDeps));
        }
    }

    private String getDependencyWording(int amount) {
        return amount > 1 ? "dependencies" : "dependency";
    }

    public AbstractDebloater(ProjectDependencyAnalysis analysis) {
        this.analysis = analysis;
    }
}

