/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.model.ClassName;
import se.kth.depclean.core.model.ProjectContext;

public class ActualUsedClasses {
    private static final Logger log = LoggerFactory.getLogger(ActualUsedClasses.class);
    private final ProjectContext context;
    private final Set<ClassName> classes = new HashSet<ClassName>();

    public ActualUsedClasses(ProjectContext context) {
        this.context = context;
    }

    private void registerClass(ClassName className) {
        if (this.context.hasNoDependencyOnClass(className)) {
            log.debug("Class {} is not known to any dependency", (Object)className);
            return;
        }
        log.debug("## Registered class {}", (Object)className);
        this.classes.add(className);
    }

    public void registerClasses(Iterable<ClassName> classes) {
        classes.forEach(this::registerClass);
    }

    public Set<ClassName> getRegisteredClasses() {
        return this.classes;
    }
}

