/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.ClassFileVisitor;

public final class ClassFileVisitorUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassFileVisitorUtils.class);
    private static final String[] CLASS_INCLUDES = new String[]{"**/*.class"};
    public static final String CLASS = ".class";

    private ClassFileVisitorUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void accept(URL url, ClassFileVisitor visitor) {
        if (url.getPath().endsWith(".jar")) {
            ClassFileVisitorUtils.acceptJar(url, visitor);
            return;
        }
        String message = "Cannot accept visitor on URL: ";
        if (!url.getProtocol().equalsIgnoreCase("file")) throw new IllegalArgumentException("Cannot accept visitor on URL: " + url + " because url isn't pointing a file.");
        try {
            File file = new File(new URI(url.toString()));
            if (file.isDirectory()) {
                ClassFileVisitorUtils.acceptDirectory(file, visitor);
                return;
            } else {
                if (!file.exists()) return;
                throw new IllegalArgumentException("Cannot accept visitor on URL: " + url + " because file is not a directory.");
            }
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException("Cannot accept visitor on URL: " + url, exception);
        }
    }

    private static void acceptJar(URL url, ClassFileVisitor visitor) {
        try (JarInputStream in = new JarInputStream(url.openStream());){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(CLASS) || name.indexOf(45) != -1) continue;
                ClassFileVisitorUtils.visitClass(name, in, visitor);
            }
        }
        catch (IOException e) {
            log.error("Error analyzing JAR: " + url);
        }
    }

    private static void acceptDirectory(File directory, ClassFileVisitor visitor) {
        String[] paths;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File is not a directory");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(CLASS_INCLUDES);
        scanner.scan();
        for (String path : paths = scanner.getIncludedFiles()) {
            File file = new File(directory, path);
            try (FileInputStream in = new FileInputStream(file);){
                ClassFileVisitorUtils.visitClass(path, in, visitor);
            }
            catch (IOException e) {
                log.error("Error analyzing directory: " + directory.getAbsolutePath());
            }
        }
    }

    public static String getChild(String path) {
        Path tmp = Paths.get(path, new String[0]);
        if (tmp.getNameCount() > 1) {
            return tmp.subpath(1, tmp.getNameCount()).toString();
        }
        return path;
    }

    private static void visitClass(String path, InputStream in, ClassFileVisitor visitor) {
        if (!path.endsWith(CLASS)) {
            throw new IllegalArgumentException("Path is not a class");
        }
        path = ClassFileVisitorUtils.getChild(path);
        String className = path.substring(0, path.length() - CLASS.length());
        className = className.replace(File.separatorChar, '.');
        visitor.visitClass(className, in);
    }
}

