/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.ClassFileVisitor;
import se.kth.depclean.core.analysis.asm.ConstantPoolParser;
import se.kth.depclean.core.analysis.asm.DefaultAnnotationVisitor;
import se.kth.depclean.core.analysis.asm.DefaultClassVisitor;
import se.kth.depclean.core.analysis.asm.DefaultFieldVisitor;
import se.kth.depclean.core.analysis.asm.DefaultMethodVisitor;
import se.kth.depclean.core.analysis.asm.DefaultSignatureVisitor;
import se.kth.depclean.core.analysis.asm.ResultCollector;
import se.kth.depclean.core.analysis.graph.DefaultCallGraph;

public class DependencyClassFileVisitor
implements ClassFileVisitor {
    private static final Logger log = LoggerFactory.getLogger(DependencyClassFileVisitor.class);
    private final ResultCollector resultCollector = new ResultCollector();

    @Override
    public void visitClass(String className, InputStream in) {
        try {
            ClassReader reader = new ClassReader(in);
            Set<String> constantPoolClassRefs = ConstantPoolParser.getConstantPoolClassReferences(reader.b);
            for (String string : constantPoolClassRefs) {
                this.resultCollector.addName(string);
            }
            DefaultAnnotationVisitor annotationVisitor = new DefaultAnnotationVisitor(this.resultCollector);
            DefaultSignatureVisitor signatureVisitor = new DefaultSignatureVisitor(this.resultCollector);
            DefaultFieldVisitor fieldVisitor = new DefaultFieldVisitor(annotationVisitor, this.resultCollector);
            DefaultMethodVisitor methodVisitor = new DefaultMethodVisitor(annotationVisitor, signatureVisitor, this.resultCollector);
            DefaultClassVisitor defaultClassVisitor = new DefaultClassVisitor(signatureVisitor, annotationVisitor, fieldVisitor, methodVisitor, this.resultCollector);
            reader.accept((ClassVisitor)defaultClassVisitor, 0);
            DefaultCallGraph.addEdge(className, this.resultCollector.getDependencies());
        }
        catch (IOException | IndexOutOfBoundsException e) {
            log.warn("Unable to process: " + className);
        }
        this.resultCollector.clearClasses();
    }

    public Set<String> getDependencies() {
        return this.resultCollector.getDependencies();
    }
}

