/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis.asm;

import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Type;

public class ResultCollector {
    private final Set<String> classes = new HashSet<String>();

    public Set<String> getDependencies() {
        return this.classes;
    }

    public void clearClasses() {
        this.classes.clear();
    }

    public void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
                break;
            }
        }
    }

    public void add(String name) {
        this.classes.add(name);
    }

    void addNames(String[] names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            this.addName(name);
        }
    }

    void addName(String name) {
        if (name == null) {
            return;
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            name = name.substring(2, name.length() - 1);
        }
        name = name.replace('/', '.');
        this.classes.add(name);
    }

    void addMethodDesc(String desc) {
        Type[] types;
        this.addType(Type.getReturnType((String)desc));
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            this.addType(type);
        }
    }
}

