/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.DepthFirstIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCallGraph {
    private static final Logger log = LoggerFactory.getLogger(DefaultCallGraph.class);
    private static final AbstractBaseGraph<String, DefaultEdge> directedGraph = new DefaultDirectedGraph(DefaultEdge.class);
    private static final Set<String> projectVertices = new HashSet<String>();
    private static final Map<String, Set<String>> usagesPerClass = new HashMap<String, Set<String>>();

    public static void addEdge(String clazz, Set<String> referencedClassMembers) {
        directedGraph.addVertex((Object)clazz);
        for (String referencedClassMember : referencedClassMembers) {
            if (!directedGraph.containsVertex((Object)referencedClassMember)) {
                directedGraph.addVertex((Object)referencedClassMember);
            }
            directedGraph.addEdge((Object)clazz, (Object)referencedClassMember);
            projectVertices.add(clazz);
            DefaultCallGraph.addReferencedClassMember(clazz, referencedClassMember);
        }
    }

    public static Set<String> referencedClassMembers(Set<String> projectClasses) {
        log.debug("Project classes: " + projectClasses);
        HashSet<String> allReferencedClassMembers = new HashSet<String>();
        for (String projectClass : projectClasses) {
            allReferencedClassMembers.addAll(DefaultCallGraph.traverse(projectClass));
        }
        log.debug("All referenced class members: " + allReferencedClassMembers);
        return allReferencedClassMembers;
    }

    private static Set<String> traverse(String start) {
        HashSet<String> referencedClassMembers = new HashSet<String>();
        DepthFirstIterator iterator = new DepthFirstIterator(directedGraph, (Object)start);
        while (iterator.hasNext()) {
            referencedClassMembers.add((String)iterator.next());
        }
        return referencedClassMembers;
    }

    private static void addReferencedClassMember(String clazz, String referencedClassMember) {
        Set s = usagesPerClass.computeIfAbsent(clazz, k -> new HashSet());
        s.add(referencedClassMember);
    }

    public static AbstractBaseGraph<String, DefaultEdge> getDirectedGraph() {
        return directedGraph;
    }

    public static Set<String> getProjectVertices() {
        return projectVertices;
    }

    public static void clear() {
        projectVertices.clear();
        usagesPerClass.clear();
    }

    public static Map<String, Set<String>> getUsagesPerClass() {
        return usagesPerClass;
    }
}

