/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis.model;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.DependencyTypes;
import se.kth.depclean.core.analysis.graph.DependencyGraph;
import se.kth.depclean.core.analysis.model.DebloatedDependency;
import se.kth.depclean.core.analysis.model.DependencyAnalysisInfo;
import se.kth.depclean.core.model.ClassName;
import se.kth.depclean.core.model.Dependency;

public class ProjectDependencyAnalysis {
    private static final Logger log = LoggerFactory.getLogger(ProjectDependencyAnalysis.class);
    private static final String SEPARATOR = "-------------------------------------------------------";
    private final Set<Dependency> usedDirectDependencies;
    private final Set<Dependency> usedTransitiveDependencies;
    private final Set<Dependency> usedInheritedDirectDependencies;
    private final Set<Dependency> usedInheritedTransitiveDependencies;
    private final Set<Dependency> unusedDirectDependencies;
    private final Set<Dependency> unusedTransitiveDependencies;
    private final Set<Dependency> unusedInheritedDirectDependencies;
    private final Set<Dependency> unusedInheritedTransitiveDependencies;
    private final Set<Dependency> ignoredDependencies;
    private final Map<Dependency, DependencyTypes> dependencyClassesMap;
    private final DependencyGraph dependencyGraph;

    public ProjectDependencyAnalysis(Set<Dependency> usedDirectDependencies, Set<Dependency> usedTransitiveDependencies, Set<Dependency> usedInheritedDirectDependencies, Set<Dependency> usedInheritedTransitiveDependencies, Set<Dependency> unusedDirectDependencies, Set<Dependency> unusedTransitiveDependencies, Set<Dependency> unusedInheritedDirectDependencies, Set<Dependency> unusedInheritedTransitiveDependencies, Set<Dependency> ignoredDependencies, Map<Dependency, DependencyTypes> dependencyClassesMap, DependencyGraph dependencyGraph) {
        this.usedDirectDependencies = ImmutableSet.copyOf(usedDirectDependencies);
        this.usedTransitiveDependencies = ImmutableSet.copyOf(usedTransitiveDependencies);
        this.usedInheritedDirectDependencies = ImmutableSet.copyOf(usedInheritedDirectDependencies);
        this.usedInheritedTransitiveDependencies = ImmutableSet.copyOf(usedInheritedTransitiveDependencies);
        this.unusedDirectDependencies = ImmutableSet.copyOf(unusedDirectDependencies);
        this.unusedTransitiveDependencies = ImmutableSet.copyOf(unusedTransitiveDependencies);
        this.unusedInheritedDirectDependencies = ImmutableSet.copyOf(unusedInheritedDirectDependencies);
        this.unusedInheritedTransitiveDependencies = ImmutableSet.copyOf(unusedInheritedTransitiveDependencies);
        this.ignoredDependencies = ImmutableSet.copyOf(ignoredDependencies);
        this.dependencyClassesMap = dependencyClassesMap;
        this.dependencyGraph = dependencyGraph;
    }

    public boolean hasUsedTransitiveDependencies() {
        return !this.usedTransitiveDependencies.isEmpty();
    }

    public boolean hasUnusedDirectDependencies() {
        return !this.unusedDirectDependencies.isEmpty();
    }

    public boolean hasUnusedTransitiveDependencies() {
        return !this.unusedTransitiveDependencies.isEmpty();
    }

    public boolean hasUnusedInheritedDirectDependencies() {
        return !this.unusedInheritedDirectDependencies.isEmpty();
    }

    public boolean hasUnusedInheritedTransitiveDependencies() {
        return !this.unusedInheritedTransitiveDependencies.isEmpty();
    }

    public void print() {
        this.printString(SEPARATOR);
        this.printString(" D E P C L E A N   A N A L Y S I S   R E S U L T S");
        this.printString(SEPARATOR);
        this.printInfoOfDependencies("Used direct dependencies", this.getUsedDirectDependencies());
        this.printInfoOfDependencies("Used transitive dependencies", this.getUsedTransitiveDependencies());
        this.printInfoOfDependencies("Used inherited direct dependencies", this.getUsedInheritedDirectDependencies());
        this.printInfoOfDependencies("Used inherited transitive dependencies", this.getUsedInheritedTransitiveDependencies());
        this.printInfoOfDependencies("Potentially unused direct dependencies", this.getUnusedDirectDependencies());
        this.printInfoOfDependencies("Potentially unused transitive dependencies", this.getUnusedTransitiveDependencies());
        this.printInfoOfDependencies("Potentially unused inherited direct dependencies", this.getUnusedInheritedDirectDependencies());
        this.printInfoOfDependencies("Potentially unused inherited transitive dependencies", this.getUnusedInheritedTransitiveDependencies());
        if (!this.ignoredDependencies.isEmpty()) {
            this.printString(SEPARATOR);
            this.printString("Dependencies ignored in the analysis by the user [" + this.ignoredDependencies.size() + "]: ");
            this.ignoredDependencies.forEach(s -> this.printString("\t" + s));
        }
    }

    public DependencyAnalysisInfo getDependencyInfo(String coordinate) {
        Dependency dependency;
        try {
            dependency = this.findByCoordinates(coordinate);
        }
        catch (RuntimeException e) {
            return null;
        }
        return new DependencyAnalysisInfo(this.getStatus(dependency), this.getType(dependency), dependency.getSize(), this.toValue(this.dependencyClassesMap.get(dependency).getAllTypes()), this.toValue(this.dependencyClassesMap.get(dependency).getUsedTypes()));
    }

    public Set<DebloatedDependency> getUsedDependencies() {
        HashSet<Dependency> dependencies = new HashSet<Dependency>(this.getUsedDirectDependencies());
        dependencies.addAll(this.getUsedInheritedDirectDependencies());
        dependencies.addAll(this.getUsedInheritedTransitiveDependencies());
        dependencies.addAll(this.getUsedTransitiveDependencies());
        return (Set)dependencies.stream().map(this::toDebloatedDependency).collect(ImmutableSet.toImmutableSet());
    }

    public Set<DebloatedDependency> getUnusedDependencies() {
        HashSet<Dependency> dependencies = new HashSet<Dependency>(this.getUnusedDirectDependencies());
        dependencies.addAll(this.getUnusedInheritedDirectDependencies());
        dependencies.addAll(this.getUnusedInheritedTransitiveDependencies());
        dependencies.addAll(this.getUnusedTransitiveDependencies());
        return (Set)dependencies.stream().map(this::toDebloatedDependency).collect(ImmutableSet.toImmutableSet());
    }

    private Dependency findByCoordinates(String coordinate) {
        return this.dependencyClassesMap.keySet().stream().filter(dc -> dc.toString().contains(coordinate)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find " + coordinate + " in dependencies"));
    }

    private TreeSet<String> toValue(Set<ClassName> types) {
        return types.stream().map(ClassName::getValue).collect(Collectors.toCollection(TreeSet::new));
    }

    private String getStatus(Dependency coordinates) {
        if (this.usedDirectDependencies.contains(coordinates) || this.usedInheritedDirectDependencies.contains(coordinates) || this.usedInheritedTransitiveDependencies.contains(coordinates) || this.usedTransitiveDependencies.contains(coordinates)) {
            return "used";
        }
        return this.unusedDirectDependencies.contains(coordinates) || this.unusedInheritedDirectDependencies.contains(coordinates) || this.unusedInheritedTransitiveDependencies.contains(coordinates) || this.unusedTransitiveDependencies.contains(coordinates) ? "bloated" : "unknown";
    }

    private String getType(Dependency coordinates) {
        if (this.usedDirectDependencies.contains(coordinates) || this.unusedDirectDependencies.contains(coordinates)) {
            return "direct";
        }
        if (this.usedInheritedDirectDependencies.contains(coordinates) || this.usedInheritedTransitiveDependencies.contains(coordinates) || this.unusedInheritedDirectDependencies.contains(coordinates) || this.unusedInheritedTransitiveDependencies.contains(coordinates)) {
            return "inherited";
        }
        return this.usedTransitiveDependencies.contains(coordinates) || this.unusedTransitiveDependencies.contains(coordinates) ? "transitive" : "unknown";
    }

    private void printString(String string) {
        System.out.println(string);
    }

    private void printInfoOfDependencies(String info, Set<Dependency> dependencies) {
        this.printString(info.toUpperCase() + " [" + dependencies.size() + "]: ");
        this.printDependencies(dependencies);
    }

    private void printDependencies(Set<Dependency> dependencies) {
        dependencies.stream().sorted(Comparator.comparing(Dependency::getSize)).collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(s -> this.printString("\t" + s.printWithSize()));
    }

    private DebloatedDependency toDebloatedDependency(Dependency dependency) {
        Set<Dependency> dependenciesForParent = this.dependencyGraph.getDependenciesForParent(dependency);
        Set dependenciesToExclude = dependenciesForParent.stream().filter(dep -> this.getUnusedTransitiveDependencies().contains(dep)).collect(Collectors.toSet());
        return new DebloatedDependency(dependency, (Set<Dependency>)ImmutableSet.copyOf(dependenciesToExclude));
    }

    public Set<Dependency> getUsedDirectDependencies() {
        return this.usedDirectDependencies;
    }

    public Set<Dependency> getUsedTransitiveDependencies() {
        return this.usedTransitiveDependencies;
    }

    public Set<Dependency> getUsedInheritedDirectDependencies() {
        return this.usedInheritedDirectDependencies;
    }

    public Set<Dependency> getUsedInheritedTransitiveDependencies() {
        return this.usedInheritedTransitiveDependencies;
    }

    public Set<Dependency> getUnusedDirectDependencies() {
        return this.unusedDirectDependencies;
    }

    public Set<Dependency> getUnusedTransitiveDependencies() {
        return this.unusedTransitiveDependencies;
    }

    public Set<Dependency> getUnusedInheritedDirectDependencies() {
        return this.unusedInheritedDirectDependencies;
    }

    public Set<Dependency> getUnusedInheritedTransitiveDependencies() {
        return this.unusedInheritedTransitiveDependencies;
    }

    public Set<Dependency> getIgnoredDependencies() {
        return this.ignoredDependencies;
    }

    public Map<Dependency, DependencyTypes> getDependencyClassesMap() {
        return this.dependencyClassesMap;
    }

    public DependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectDependencyAnalysis)) {
            return false;
        }
        ProjectDependencyAnalysis other = (ProjectDependencyAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Dependency> this$usedDirectDependencies = this.getUsedDirectDependencies();
        Set<Dependency> other$usedDirectDependencies = other.getUsedDirectDependencies();
        if (this$usedDirectDependencies == null ? other$usedDirectDependencies != null : !((Object)this$usedDirectDependencies).equals(other$usedDirectDependencies)) {
            return false;
        }
        Set<Dependency> this$usedTransitiveDependencies = this.getUsedTransitiveDependencies();
        Set<Dependency> other$usedTransitiveDependencies = other.getUsedTransitiveDependencies();
        if (this$usedTransitiveDependencies == null ? other$usedTransitiveDependencies != null : !((Object)this$usedTransitiveDependencies).equals(other$usedTransitiveDependencies)) {
            return false;
        }
        Set<Dependency> this$usedInheritedDirectDependencies = this.getUsedInheritedDirectDependencies();
        Set<Dependency> other$usedInheritedDirectDependencies = other.getUsedInheritedDirectDependencies();
        if (this$usedInheritedDirectDependencies == null ? other$usedInheritedDirectDependencies != null : !((Object)this$usedInheritedDirectDependencies).equals(other$usedInheritedDirectDependencies)) {
            return false;
        }
        Set<Dependency> this$usedInheritedTransitiveDependencies = this.getUsedInheritedTransitiveDependencies();
        Set<Dependency> other$usedInheritedTransitiveDependencies = other.getUsedInheritedTransitiveDependencies();
        if (this$usedInheritedTransitiveDependencies == null ? other$usedInheritedTransitiveDependencies != null : !((Object)this$usedInheritedTransitiveDependencies).equals(other$usedInheritedTransitiveDependencies)) {
            return false;
        }
        Set<Dependency> this$unusedDirectDependencies = this.getUnusedDirectDependencies();
        Set<Dependency> other$unusedDirectDependencies = other.getUnusedDirectDependencies();
        if (this$unusedDirectDependencies == null ? other$unusedDirectDependencies != null : !((Object)this$unusedDirectDependencies).equals(other$unusedDirectDependencies)) {
            return false;
        }
        Set<Dependency> this$unusedTransitiveDependencies = this.getUnusedTransitiveDependencies();
        Set<Dependency> other$unusedTransitiveDependencies = other.getUnusedTransitiveDependencies();
        if (this$unusedTransitiveDependencies == null ? other$unusedTransitiveDependencies != null : !((Object)this$unusedTransitiveDependencies).equals(other$unusedTransitiveDependencies)) {
            return false;
        }
        Set<Dependency> this$unusedInheritedDirectDependencies = this.getUnusedInheritedDirectDependencies();
        Set<Dependency> other$unusedInheritedDirectDependencies = other.getUnusedInheritedDirectDependencies();
        if (this$unusedInheritedDirectDependencies == null ? other$unusedInheritedDirectDependencies != null : !((Object)this$unusedInheritedDirectDependencies).equals(other$unusedInheritedDirectDependencies)) {
            return false;
        }
        Set<Dependency> this$unusedInheritedTransitiveDependencies = this.getUnusedInheritedTransitiveDependencies();
        Set<Dependency> other$unusedInheritedTransitiveDependencies = other.getUnusedInheritedTransitiveDependencies();
        if (this$unusedInheritedTransitiveDependencies == null ? other$unusedInheritedTransitiveDependencies != null : !((Object)this$unusedInheritedTransitiveDependencies).equals(other$unusedInheritedTransitiveDependencies)) {
            return false;
        }
        Set<Dependency> this$ignoredDependencies = this.getIgnoredDependencies();
        Set<Dependency> other$ignoredDependencies = other.getIgnoredDependencies();
        if (this$ignoredDependencies == null ? other$ignoredDependencies != null : !((Object)this$ignoredDependencies).equals(other$ignoredDependencies)) {
            return false;
        }
        Map<Dependency, DependencyTypes> this$dependencyClassesMap = this.getDependencyClassesMap();
        Map<Dependency, DependencyTypes> other$dependencyClassesMap = other.getDependencyClassesMap();
        if (this$dependencyClassesMap == null ? other$dependencyClassesMap != null : !((Object)this$dependencyClassesMap).equals(other$dependencyClassesMap)) {
            return false;
        }
        DependencyGraph this$dependencyGraph = this.getDependencyGraph();
        DependencyGraph other$dependencyGraph = other.getDependencyGraph();
        return !(this$dependencyGraph == null ? other$dependencyGraph != null : !this$dependencyGraph.equals(other$dependencyGraph));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectDependencyAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Dependency> $usedDirectDependencies = this.getUsedDirectDependencies();
        result = result * 59 + ($usedDirectDependencies == null ? 43 : ((Object)$usedDirectDependencies).hashCode());
        Set<Dependency> $usedTransitiveDependencies = this.getUsedTransitiveDependencies();
        result = result * 59 + ($usedTransitiveDependencies == null ? 43 : ((Object)$usedTransitiveDependencies).hashCode());
        Set<Dependency> $usedInheritedDirectDependencies = this.getUsedInheritedDirectDependencies();
        result = result * 59 + ($usedInheritedDirectDependencies == null ? 43 : ((Object)$usedInheritedDirectDependencies).hashCode());
        Set<Dependency> $usedInheritedTransitiveDependencies = this.getUsedInheritedTransitiveDependencies();
        result = result * 59 + ($usedInheritedTransitiveDependencies == null ? 43 : ((Object)$usedInheritedTransitiveDependencies).hashCode());
        Set<Dependency> $unusedDirectDependencies = this.getUnusedDirectDependencies();
        result = result * 59 + ($unusedDirectDependencies == null ? 43 : ((Object)$unusedDirectDependencies).hashCode());
        Set<Dependency> $unusedTransitiveDependencies = this.getUnusedTransitiveDependencies();
        result = result * 59 + ($unusedTransitiveDependencies == null ? 43 : ((Object)$unusedTransitiveDependencies).hashCode());
        Set<Dependency> $unusedInheritedDirectDependencies = this.getUnusedInheritedDirectDependencies();
        result = result * 59 + ($unusedInheritedDirectDependencies == null ? 43 : ((Object)$unusedInheritedDirectDependencies).hashCode());
        Set<Dependency> $unusedInheritedTransitiveDependencies = this.getUnusedInheritedTransitiveDependencies();
        result = result * 59 + ($unusedInheritedTransitiveDependencies == null ? 43 : ((Object)$unusedInheritedTransitiveDependencies).hashCode());
        Set<Dependency> $ignoredDependencies = this.getIgnoredDependencies();
        result = result * 59 + ($ignoredDependencies == null ? 43 : ((Object)$ignoredDependencies).hashCode());
        Map<Dependency, DependencyTypes> $dependencyClassesMap = this.getDependencyClassesMap();
        result = result * 59 + ($dependencyClassesMap == null ? 43 : ((Object)$dependencyClassesMap).hashCode());
        DependencyGraph $dependencyGraph = this.getDependencyGraph();
        result = result * 59 + ($dependencyGraph == null ? 43 : $dependencyGraph.hashCode());
        return result;
    }
}

