/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.analysis.src;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(ImportsAnalyzer.class);
    private Path directoryPath;

    public Set<String> collectImportedClassesFromSource() {
        HashSet<String> importsSet = new HashSet<String>();
        JavaProjectBuilder builder = new JavaProjectBuilder();
        String[] extensions = new String[]{"java"};
        File directory = new File(this.directoryPath.toUri());
        if (directory.canRead() && directory.isDirectory()) {
            List files = (List)FileUtils.listFiles((File)this.directoryPath.toFile(), (String[])extensions, (boolean)true);
            for (File file : files) {
                try {
                    builder.addSource(file);
                }
                catch (IOException | RuntimeException e) {
                    log.info("Cannot analyze imports in file: " + file.getAbsolutePath());
                }
            }
            Collection javaClasses = builder.getClasses();
            for (JavaClass javaClass : javaClasses) {
                List imports = javaClass.getSource().getImports();
                importsSet.addAll(imports);
            }
        }
        return importsSet;
    }

    public Path getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(Path directoryPath) {
        this.directoryPath = directoryPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportsAnalyzer)) {
            return false;
        }
        ImportsAnalyzer other = (ImportsAnalyzer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$directoryPath = this.getDirectoryPath();
        Path other$directoryPath = other.getDirectoryPath();
        return !(this$directoryPath == null ? other$directoryPath != null : !((Object)this$directoryPath).equals(other$directoryPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportsAnalyzer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $directoryPath = this.getDirectoryPath();
        result = result * 59 + ($directoryPath == null ? 43 : ((Object)$directoryPath).hashCode());
        return result;
    }

    public String toString() {
        return "ImportsAnalyzer(directoryPath=" + this.getDirectoryPath() + ")";
    }

    public ImportsAnalyzer(Path directoryPath) {
        this.directoryPath = directoryPath;
    }
}

