/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.model;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.DefaultClassAnalyzer;
import se.kth.depclean.core.model.ClassName;

public class Dependency {
    private static final Logger log = LoggerFactory.getLogger(Dependency.class);
    private final String groupId;
    private final String dependencyId;
    private final String version;
    private final String scope;
    private final File file;
    private final Long size;
    private final Iterable<ClassName> relatedClasses;

    public Dependency(String groupId, String dependencyId, String version, String scope, File file) {
        this.groupId = groupId;
        this.dependencyId = dependencyId;
        this.version = version;
        this.scope = scope;
        this.file = file;
        this.relatedClasses = this.findRelatedClasses();
        this.size = this.calculateSize(file);
    }

    public Dependency(String groupId, String dependencyId, String version, File file) {
        this(groupId, dependencyId, version, null, file);
    }

    protected Dependency(Dependency dependency) {
        this(dependency.getGroupId(), dependency.getDependencyId(), dependency.getVersion(), dependency.getScope(), dependency.getFile());
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.groupId, this.dependencyId, this.version, this.scope);
    }

    public String printWithSize() {
        return String.format("%s (%s)", this, FileUtils.byteCountToDisplaySize((long)this.getSize()));
    }

    private Iterable<ClassName> findRelatedClasses() {
        HashSet<ClassName> relatedClasses = new HashSet<ClassName>();
        if (this.file != null && this.file.getName().endsWith(".jar")) {
            try (JarFile jarFile = new JarFile(this.file);){
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String entry = jarEntries.nextElement().getName();
                    if (!entry.endsWith(".class")) continue;
                    relatedClasses.add(new ClassName(entry));
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (this.file != null && this.file.isDirectory()) {
            try {
                URL url = this.file.toURI().toURL();
                DefaultClassAnalyzer classAnalyzer = new DefaultClassAnalyzer();
                Set<String> classes = classAnalyzer.analyze(url);
                classes.forEach(c -> relatedClasses.add(new ClassName((String)c)));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.trace("Finding related classes for Dependency: " + this.groupId + ":" + this.dependencyId + ":" + this.version + ":" + this.scope + ":" + this.file);
        log.trace("Related classes: " + relatedClasses);
        return ImmutableSet.copyOf(relatedClasses);
    }

    private Long calculateSize(File file) {
        try {
            return FileUtils.sizeOf((File)file);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return 0L;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.dependencyId, that.dependencyId) && Objects.equals(this.version, that.version) && Objects.equals(this.scope, that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.dependencyId, this.version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDependencyId() {
        return this.dependencyId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public File getFile() {
        return this.file;
    }

    public Long getSize() {
        return this.size;
    }

    public Iterable<ClassName> getRelatedClasses() {
        return this.relatedClasses;
    }
}

