/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.graph.DependencyGraph;
import se.kth.depclean.core.model.ClassName;
import se.kth.depclean.core.model.Dependency;
import se.kth.depclean.core.model.Scope;

public final class ProjectContext {
    private static final Logger log = LoggerFactory.getLogger(ProjectContext.class);
    private final Multimap<Dependency, ClassName> classesPerDependency = ArrayListMultimap.create();
    private final Multimap<ClassName, Dependency> dependenciesPerClass = ArrayListMultimap.create();
    private final Set<Path> outputFolders;
    private final Set<Path> testOutputFolders;
    private final Path sourceFolder;
    private final Path testFolder;
    private final Path dependenciesFolder;
    private final Set<Scope> ignoredScopes;
    private final Set<Dependency> ignoredDependencies;
    private final Set<ClassName> extraClasses;
    private final DependencyGraph dependencyGraph;

    public ProjectContext(DependencyGraph dependencyGraph, Set<Path> outputFolders, Set<Path> testOutputFolders, Path sourceFolder, Path tesSourceFolder, Path dependenciesFolder, Set<Scope> ignoredScopes, Set<Dependency> ignoredDependencies, Set<ClassName> extraClasses) {
        this.dependencyGraph = dependencyGraph;
        this.outputFolders = outputFolders;
        this.testOutputFolders = testOutputFolders;
        this.sourceFolder = sourceFolder;
        this.testFolder = tesSourceFolder;
        this.dependenciesFolder = dependenciesFolder;
        this.ignoredScopes = ignoredScopes;
        this.ignoredDependencies = ignoredDependencies;
        this.extraClasses = extraClasses;
        ignoredScopes.forEach(scope -> log.info("Ignoring scope {}", scope));
        this.populateDependenciesAndClassesMap(dependencyGraph.directDependencies());
        this.populateDependenciesAndClassesMap(dependencyGraph.inheritedDirectDependencies());
        this.populateDependenciesAndClassesMap(dependencyGraph.inheritedTransitiveDependencies());
        this.populateDependenciesAndClassesMap(dependencyGraph.transitiveDependencies());
        Multimaps.invertFrom(this.classesPerDependency, this.dependenciesPerClass);
    }

    public Set<ClassName> getClassesForDependency(Dependency dependency) {
        return ImmutableSet.copyOf((Collection)this.classesPerDependency.get((Object)dependency));
    }

    public Set<Dependency> getDependenciesForClass(ClassName className) {
        return ImmutableSet.copyOf((Collection)this.dependenciesPerClass.get((Object)className));
    }

    public boolean hasNoDependencyOnClass(ClassName className) {
        return Iterables.isEmpty(this.getDependenciesForClass(className));
    }

    public Set<Dependency> getAllDependencies() {
        HashSet<Dependency> dependencies = new HashSet<Dependency>(this.dependencyGraph.allDependencies());
        dependencies.add(this.dependencyGraph.projectCoordinates());
        return ImmutableSet.copyOf(dependencies);
    }

    public boolean ignoreTests() {
        return this.ignoredScopes.contains(new Scope("test"));
    }

    private void populateDependenciesAndClassesMap(Set<Dependency> dependencies) {
        dependencies.stream().filter(this::excludeDependenciesBasedOnIgnoredScopes).forEach(dc -> {
            log.debug("Adding dependency {} with related classes: {}", dc, dc.getRelatedClasses());
            this.classesPerDependency.putAll(dc, dc.getRelatedClasses());
        });
    }

    private boolean excludeDependenciesBasedOnIgnoredScopes(Dependency dc) {
        String declaredScope = dc.getScope();
        log.debug("ignoreScopes: " + this.ignoredScopes);
        log.debug("dc = " + dc + " declaredScope = " + declaredScope);
        return this.ignoredScopes.stream().map(Scope::getValue).noneMatch(declaredScope::equalsIgnoreCase);
    }

    public String toString() {
        return "ProjectContext(classesPerDependency=" + this.classesPerDependency + ", dependenciesPerClass=" + this.dependenciesPerClass + ", outputFolders=" + this.getOutputFolders() + ", testOutputFolders=" + this.getTestOutputFolders() + ", sourceFolder=" + this.getSourceFolder() + ", testFolder=" + this.getTestFolder() + ", dependenciesFolder=" + this.getDependenciesFolder() + ", ignoredScopes=" + this.getIgnoredScopes() + ", ignoredDependencies=" + this.getIgnoredDependencies() + ", extraClasses=" + this.getExtraClasses() + ", dependencyGraph=" + this.getDependencyGraph() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectContext)) {
            return false;
        }
        ProjectContext other = (ProjectContext)o;
        Multimap<Dependency, ClassName> this$classesPerDependency = this.classesPerDependency;
        Multimap<Dependency, ClassName> other$classesPerDependency = other.classesPerDependency;
        if (this$classesPerDependency == null ? other$classesPerDependency != null : !this$classesPerDependency.equals(other$classesPerDependency)) {
            return false;
        }
        Multimap<ClassName, Dependency> this$dependenciesPerClass = this.dependenciesPerClass;
        Multimap<ClassName, Dependency> other$dependenciesPerClass = other.dependenciesPerClass;
        if (this$dependenciesPerClass == null ? other$dependenciesPerClass != null : !this$dependenciesPerClass.equals(other$dependenciesPerClass)) {
            return false;
        }
        Set<Path> this$outputFolders = this.getOutputFolders();
        Set<Path> other$outputFolders = other.getOutputFolders();
        if (this$outputFolders == null ? other$outputFolders != null : !((Object)this$outputFolders).equals(other$outputFolders)) {
            return false;
        }
        Set<Path> this$testOutputFolders = this.getTestOutputFolders();
        Set<Path> other$testOutputFolders = other.getTestOutputFolders();
        if (this$testOutputFolders == null ? other$testOutputFolders != null : !((Object)this$testOutputFolders).equals(other$testOutputFolders)) {
            return false;
        }
        Path this$sourceFolder = this.getSourceFolder();
        Path other$sourceFolder = other.getSourceFolder();
        if (this$sourceFolder == null ? other$sourceFolder != null : !((Object)this$sourceFolder).equals(other$sourceFolder)) {
            return false;
        }
        Path this$testFolder = this.getTestFolder();
        Path other$testFolder = other.getTestFolder();
        if (this$testFolder == null ? other$testFolder != null : !((Object)this$testFolder).equals(other$testFolder)) {
            return false;
        }
        Path this$dependenciesFolder = this.getDependenciesFolder();
        Path other$dependenciesFolder = other.getDependenciesFolder();
        if (this$dependenciesFolder == null ? other$dependenciesFolder != null : !((Object)this$dependenciesFolder).equals(other$dependenciesFolder)) {
            return false;
        }
        Set<Scope> this$ignoredScopes = this.getIgnoredScopes();
        Set<Scope> other$ignoredScopes = other.getIgnoredScopes();
        if (this$ignoredScopes == null ? other$ignoredScopes != null : !((Object)this$ignoredScopes).equals(other$ignoredScopes)) {
            return false;
        }
        Set<Dependency> this$ignoredDependencies = this.getIgnoredDependencies();
        Set<Dependency> other$ignoredDependencies = other.getIgnoredDependencies();
        if (this$ignoredDependencies == null ? other$ignoredDependencies != null : !((Object)this$ignoredDependencies).equals(other$ignoredDependencies)) {
            return false;
        }
        Set<ClassName> this$extraClasses = this.getExtraClasses();
        Set<ClassName> other$extraClasses = other.getExtraClasses();
        if (this$extraClasses == null ? other$extraClasses != null : !((Object)this$extraClasses).equals(other$extraClasses)) {
            return false;
        }
        DependencyGraph this$dependencyGraph = this.getDependencyGraph();
        DependencyGraph other$dependencyGraph = other.getDependencyGraph();
        return !(this$dependencyGraph == null ? other$dependencyGraph != null : !this$dependencyGraph.equals(other$dependencyGraph));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap<Dependency, ClassName> $classesPerDependency = this.classesPerDependency;
        result = result * 59 + ($classesPerDependency == null ? 43 : $classesPerDependency.hashCode());
        Multimap<ClassName, Dependency> $dependenciesPerClass = this.dependenciesPerClass;
        result = result * 59 + ($dependenciesPerClass == null ? 43 : $dependenciesPerClass.hashCode());
        Set<Path> $outputFolders = this.getOutputFolders();
        result = result * 59 + ($outputFolders == null ? 43 : ((Object)$outputFolders).hashCode());
        Set<Path> $testOutputFolders = this.getTestOutputFolders();
        result = result * 59 + ($testOutputFolders == null ? 43 : ((Object)$testOutputFolders).hashCode());
        Path $sourceFolder = this.getSourceFolder();
        result = result * 59 + ($sourceFolder == null ? 43 : ((Object)$sourceFolder).hashCode());
        Path $testFolder = this.getTestFolder();
        result = result * 59 + ($testFolder == null ? 43 : ((Object)$testFolder).hashCode());
        Path $dependenciesFolder = this.getDependenciesFolder();
        result = result * 59 + ($dependenciesFolder == null ? 43 : ((Object)$dependenciesFolder).hashCode());
        Set<Scope> $ignoredScopes = this.getIgnoredScopes();
        result = result * 59 + ($ignoredScopes == null ? 43 : ((Object)$ignoredScopes).hashCode());
        Set<Dependency> $ignoredDependencies = this.getIgnoredDependencies();
        result = result * 59 + ($ignoredDependencies == null ? 43 : ((Object)$ignoredDependencies).hashCode());
        Set<ClassName> $extraClasses = this.getExtraClasses();
        result = result * 59 + ($extraClasses == null ? 43 : ((Object)$extraClasses).hashCode());
        DependencyGraph $dependencyGraph = this.getDependencyGraph();
        result = result * 59 + ($dependencyGraph == null ? 43 : $dependencyGraph.hashCode());
        return result;
    }

    public Set<Path> getOutputFolders() {
        return this.outputFolders;
    }

    public Set<Path> getTestOutputFolders() {
        return this.testOutputFolders;
    }

    public Path getSourceFolder() {
        return this.sourceFolder;
    }

    public Path getTestFolder() {
        return this.testFolder;
    }

    public Path getDependenciesFolder() {
        return this.dependenciesFolder;
    }

    public Set<Scope> getIgnoredScopes() {
        return this.ignoredScopes;
    }

    public Set<Dependency> getIgnoredDependencies() {
        return this.ignoredDependencies;
    }

    public Set<ClassName> getExtraClasses() {
        return this.extraClasses;
    }

    public DependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }
}

