/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarUtils {
    private static final Logger log = LoggerFactory.getLogger(JarUtils.class);
    private static final int BUFFER_SIZE = 16384;

    private JarUtils() {
    }

    public static void decompress(String outputDirectory) {
        File files = new File(outputDirectory);
        for (File f : Objects.requireNonNull(files.listFiles())) {
            if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".war") && !f.getName().endsWith(".ear")) continue;
            try {
                JarUtils.decompressDependencyFiles(f.getAbsolutePath());
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                log.warn("Problem decompressing jar file: " + f.getAbsolutePath());
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void decompressDependencyFiles(String zipFile) throws IOException {
        File file = new File(zipFile);
        try (ZipFile zip = new ZipFile(file);){
            String newPath = zipFile.substring(0, zipFile.length() - 4);
            new File(newPath).mkdir();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(newPath, currentEntry);
                if (!destFile.getCanonicalPath().startsWith(new File(newPath).getCanonicalPath())) {
                    throw new IOException("Entry is outside of the target directory");
                }
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (!entry.isDirectory()) {
                    BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] data = new byte[16384];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 16384);){
                        int currentByte;
                        while ((currentByte = is.read(data, 0, 16384)) != -1) {
                            dest.write(data, 0, currentByte);
                        }
                        dest.flush();
                        is.close();
                    }
                }
                if (!currentEntry.endsWith(".jar") && !currentEntry.endsWith(".war") && !currentEntry.endsWith(".ear")) continue;
                JarUtils.decompressDependencyFiles(destFile.getAbsolutePath());
                FileUtils.forceDelete((File)new File(destFile.getAbsolutePath()));
            }
        }
    }
}

