/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import se.unlogic.standardutils.callback.Callback;
import se.unlogic.standardutils.streams.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static String toAsciiFilename(String string) {
        return string.replaceAll("[^0-9a-zA-Z-.]", "_");
    }

    public static String toValidHttpFilename(String string) {
        return string.replaceAll("[^0-9a-\u00f6A-\u00d6-+. ()-+!@\u00e9&%$\u00a7=\u00b4]", "_");
    }

    public static final byte[] getRawBytes(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        byte[] buffer = new byte[(int)f.length()];
        fin.read(buffer);
        fin.close();
        return buffer;
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex + 1 == filename.length()) {
            return null;
        }
        return filename.substring(dotIndex + 1);
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static int deleteFiles(String directory, FileFilter filter, boolean recursive) {
        return FileUtils.deleteFiles(new File(directory), filter, recursive);
    }

    public static int deleteFiles(File dir, FileFilter filter, boolean recursive) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            int deletedFiles = 0;
            File[] fileArray = files = dir.listFiles(filter);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (recursive) {
                        deletedFiles += FileUtils.deleteFiles(file, filter, recursive);
                    }
                } else if (file.delete()) {
                    ++deletedFiles;
                }
                ++n2;
            }
            return deletedFiles;
        }
        return 0;
    }

    public static int replace(File dir, String filename, File replacementFile, boolean recursive, boolean caseSensitive, Callback<File> callback) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            int replacedFiles = 0;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (recursive) {
                        replacedFiles += FileUtils.replace(file, filename, replacementFile, recursive, caseSensitive, callback);
                    }
                } else if (!(!caseSensitive ? !file.getName().equalsIgnoreCase(filename) : !file.getName().equals(filename)) && file.canWrite()) {
                    try {
                        if (callback != null) {
                            callback.callback(file);
                        }
                        FileUtils.replaceFile(file, replacementFile);
                        ++replacedFiles;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            return replacedFiles;
        }
        return 0;
    }

    public static void replaceFile(File target, File replacement) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(replacement);
            outputStream = new FileOutputStream(target);
            inputStream.getChannel().transferTo(0L, replacement.length(), outputStream.getChannel());
            StreamUtils.transfer(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(inputStream);
            StreamUtils.closeStream(outputStream);
            throw throwable;
        }
        StreamUtils.closeStream(inputStream);
        StreamUtils.closeStream(outputStream);
    }

    public static boolean deleteDirectory(String directoryPath) {
        return FileUtils.deleteDirectory(new File(directoryPath));
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.exists()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

