/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.VisitedObjects;

public class EntityInput
extends TupleInput {
    private Catalog catalog;
    boolean rawAccess;
    private VisitedObjects visited;
    private DatabaseEntry priKeyEntry;
    private int priKeyFormatId;

    EntityInput(Catalog catalog, boolean rawAccess, DatabaseEntry priKeyEntry, int priKeyFormatId, byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        this.catalog = catalog;
        this.rawAccess = rawAccess;
        this.priKeyEntry = priKeyEntry;
        this.priKeyFormatId = priKeyFormatId;
    }

    private EntityInput(EntityInput other, int offset) {
        this(other.catalog, other.rawAccess, other.priKeyEntry, other.priKeyFormatId, other.buf, offset, other.len);
        this.visited = other.visited;
    }

    private EntityInput(EntityInput other, DatabaseEntry entry) {
        this(other.catalog, other.rawAccess, other.priKeyEntry, other.priKeyFormatId, entry.getData(), entry.getOffset(), entry.getSize());
        this.visited = other.visited;
    }

    Catalog getCatalog() {
        return this.catalog;
    }

    public Object readObject() {
        int visitedOffset = this.off;
        EntityInput useInput = this;
        int formatId = this.readPackedInt();
        Object o = null;
        if (formatId == 0) {
            return null;
        }
        if (formatId < 0) {
            int offset = -(formatId + 1);
            if (this.visited != null) {
                o = this.visited.getObject(offset);
            }
            if (o != null) {
                return o;
            }
            visitedOffset = offset;
            if (offset == 0x7FFFFFFE) {
                assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                useInput = new EntityInput(this, this.priKeyEntry);
                formatId = this.priKeyFormatId;
            } else {
                useInput = new EntityInput(this, offset);
                formatId = useInput.readPackedInt();
            }
        }
        Format format = this.catalog.getFormat(formatId);
        o = format.newInstance(useInput, this.rawAccess);
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(o, visitedOffset);
        format.readObject(o, useInput, this.rawAccess);
        return o;
    }

    public Object readKeyObject(Format format) {
        Object o = format.newInstance(this, this.rawAccess);
        format.readObject(o, this, this.rawAccess);
        return o;
    }

    KeyLocation getKeyLocation(Format fieldFormat) {
        EntityInput input = this;
        if (!fieldFormat.isPrimitive()) {
            int formatId = input.readPackedInt();
            if (formatId == 0) {
                return null;
            }
            if (formatId < 0) {
                int offset = -(formatId + 1);
                if (offset == 0x7FFFFFFE) {
                    assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                    input = new EntityInput(this, this.priKeyEntry);
                    formatId = this.priKeyFormatId;
                } else {
                    input = new EntityInput(this, offset);
                    formatId = input.readPackedInt();
                }
            }
            fieldFormat = this.catalog.getFormat(formatId);
        }
        return new KeyLocation(input, fieldFormat);
    }

    public void registerPriKeyObject(Object o) {
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(o, 0x7FFFFFFE);
    }

    void skipField(Format declaredFormat) {
        if (declaredFormat != null && declaredFormat.isPrimitive()) {
            declaredFormat.skipContents(this);
        } else {
            int formatId = this.readPackedInt();
            if (formatId > 0) {
                Format format = this.catalog.getFormat(formatId);
                format.skipContents(this);
            }
        }
    }
}

