package software.amazon.awscdk;

/**
 * Represents a special or lazily-evaluated value.
 * <p>
 * Can be used to delay evaluation of a certain value in case, for example,
 * that it requires some context or late-bound data. Can also be used to
 * mark values that need special processing at document rendering time.
 * <p>
 * Tokens can be embedded into strings while retaining their original
 * semantics.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.185Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Token")
public class Token extends software.amazon.jsii.JsiiObject {

    protected Token(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Token(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Return a resolvable representation of the given value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable asAny(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "asAny", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { value });
    }

    /**
     * Return a reversible list representation of this token.
     * <p>
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> asList(final @org.jetbrains.annotations.NotNull java.lang.Object value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.EncodingOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "asList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { value, options }));
    }

    /**
     * Return a reversible list representation of this token.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> asList(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "asList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { value }));
    }

    /**
     * Return a reversible number representation of this token.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number asNumber(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "asNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { value });
    }

    /**
     * Return a reversible string representation of this token.
     * <p>
     * If the Token is initialized with a literal, the stringified value of the
     * literal is returned. Otherwise, a special quoted string representation
     * of the Token is returned that can be embedded into other strings.
     * <p>
     * Strings with quoted Tokens in them can be restored back into
     * complex values with the Tokens restored by calling <code>resolve()</code>
     * on the string.
     * <p>
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String asString(final @org.jetbrains.annotations.NotNull java.lang.Object value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.EncodingOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "asString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { value, options });
    }

    /**
     * Return a reversible string representation of this token.
     * <p>
     * If the Token is initialized with a literal, the stringified value of the
     * literal is returned. Otherwise, a special quoted string representation
     * of the Token is returned that can be embedded into other strings.
     * <p>
     * Strings with quoted Tokens in them can be restored back into
     * complex values with the Tokens restored by calling <code>resolve()</code>
     * on the string.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String asString(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "asString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { value });
    }

    /**
     * Compare two strings that might contain Tokens with each other.
     * <p>
     * @param possibleToken1 This parameter is required.
     * @param possibleToken2 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.TokenComparison compareStrings(final @org.jetbrains.annotations.NotNull java.lang.String possibleToken1, final @org.jetbrains.annotations.NotNull java.lang.String possibleToken2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "compareStrings", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TokenComparison.class), new Object[] { java.util.Objects.requireNonNull(possibleToken1, "possibleToken1 is required"), java.util.Objects.requireNonNull(possibleToken2, "possibleToken2 is required") });
    }

    /**
     * Returns true if obj represents an unresolved value.
     * <p>
     * One of these must be true:
     * <p>
     * <ul>
     * <li><code>obj</code> is an IResolvable</li>
     * <li><code>obj</code> is a string containing at least one encoded <code>IResolvable</code></li>
     * <li><code>obj</code> is either an encoded number or list</li>
     * </ul>
     * <p>
     * This does NOT recurse into lists or objects to see if they
     * contain resolvables.
     * <p>
     * @param obj The object to test. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isUnresolved(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Token.class, "isUnresolved", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { obj });
    }
}
