package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * Lambda Proxy integration properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.*;
 * ParameterMapping parameterMapping;
 * PayloadFormatVersion payloadFormatVersion;
 * HttpLambdaIntegrationProps httpLambdaIntegrationProps = HttpLambdaIntegrationProps.builder()
 *         .parameterMapping(parameterMapping)
 *         .payloadFormatVersion(payloadFormatVersion)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.766Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpLambdaIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(HttpLambdaIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpLambdaIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     * <p>
     * Default: undefined requests are sent to the backend unmodified
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
        return null;
    }

    /**
     * Version of the payload sent to the lambda handler.
     * <p>
     * Default: PayloadFormatVersion.VERSION_2_0
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpLambdaIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpLambdaIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpLambdaIntegrationProps> {
        software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion;

        /**
         * Sets the value of {@link HttpLambdaIntegrationProps#getParameterMapping}
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.parameterMapping = parameterMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpLambdaIntegrationProps#getPayloadFormatVersion}
         * @param payloadFormatVersion Version of the payload sent to the lambda handler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payloadFormatVersion(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpLambdaIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpLambdaIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpLambdaIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpLambdaIntegrationProps {
        private final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        private final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameterMapping = software.amazon.jsii.Kernel.get(this, "parameterMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class));
            this.payloadFormatVersion = software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameterMapping = builder.parameterMapping;
            this.payloadFormatVersion = builder.payloadFormatVersion;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
            return this.parameterMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getParameterMapping() != null) {
                data.set("parameterMapping", om.valueToTree(this.getParameterMapping()));
            }
            if (this.getPayloadFormatVersion() != null) {
                data.set("payloadFormatVersion", om.valueToTree(this.getPayloadFormatVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_integrations.HttpLambdaIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpLambdaIntegrationProps.Jsii$Proxy that = (HttpLambdaIntegrationProps.Jsii$Proxy) o;

            if (this.parameterMapping != null ? !this.parameterMapping.equals(that.parameterMapping) : that.parameterMapping != null) return false;
            return this.payloadFormatVersion != null ? this.payloadFormatVersion.equals(that.payloadFormatVersion) : that.payloadFormatVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parameterMapping != null ? this.parameterMapping.hashCode() : 0;
            result = 31 * result + (this.payloadFormatVersion != null ? this.payloadFormatVersion.hashCode() : 0);
            return result;
        }
    }
}
