package software.amazon.awscdk.services.appmesh;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * VirtualRouter router = mesh.addVirtualRouter("router", VirtualRouterBaseProps.builder()
 *         .listeners(List.of(VirtualRouterListener.http(8080)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.257Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualRouter")
public class VirtualRouter extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appmesh.IVirtualRouter {

    protected VirtualRouter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualRouter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VirtualRouter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualRouterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing VirtualRouter given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param virtualRouterArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualRouter fromVirtualRouterArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String virtualRouterArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualRouter.class, "fromVirtualRouterArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualRouter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(virtualRouterArn, "virtualRouterArn is required") });
    }

    /**
     * Import an existing VirtualRouter given attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualRouter fromVirtualRouterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualRouterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualRouter.class, "fromVirtualRouterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualRouter.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a single route to the router.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.Route addRoute(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "addRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.Route.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The Mesh which the VirtualRouter belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh() {
        return software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the VirtualRouter.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterArn() {
        return software.amazon.jsii.Kernel.get(this, "virtualRouterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the VirtualRouter.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterName() {
        return software.amazon.jsii.Kernel.get(this, "virtualRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.VirtualRouter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.VirtualRouter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.VirtualRouterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.VirtualRouterProps.Builder();
        }

        /**
         * Listener specification for the VirtualRouter.
         * <p>
         * Default: - A listener on HTTP port 8080
         * <p>
         * @return {@code this}
         * @param listeners Listener specification for the VirtualRouter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualRouterListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * The name of the VirtualRouter.
         * <p>
         * Default: - A name is automatically determined
         * <p>
         * @return {@code this}
         * @param virtualRouterName The name of the VirtualRouter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterName(final java.lang.String virtualRouterName) {
            this.props.virtualRouterName(virtualRouterName);
            return this;
        }

        /**
         * The Mesh which the VirtualRouter belongs to.
         * <p>
         * @return {@code this}
         * @param mesh The Mesh which the VirtualRouter belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(final software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.VirtualRouter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.VirtualRouter build() {
            return new software.amazon.awscdk.services.appmesh.VirtualRouter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
