package software.amazon.awscdk.services.appmesh;

/**
 * Properties for a VirtualService provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * Mesh mesh;
 * VirtualServiceProviderConfig virtualServiceProviderConfig = VirtualServiceProviderConfig.builder()
 *         .mesh(mesh)
 *         // the properties below are optional
 *         .virtualNodeProvider(VirtualNodeServiceProviderProperty.builder()
 *                 .virtualNodeName("virtualNodeName")
 *                 .build())
 *         .virtualRouterProvider(VirtualRouterServiceProviderProperty.builder()
 *                 .virtualRouterName("virtualRouterName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.262Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualServiceProviderConfig")
@software.amazon.jsii.Jsii.Proxy(VirtualServiceProviderConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualServiceProviderConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Mesh the Provider is using.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh();

    /**
     * Virtual Node based provider.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty getVirtualNodeProvider() {
        return null;
    }

    /**
     * Virtual Router based provider.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty getVirtualRouterProvider() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VirtualServiceProviderConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualServiceProviderConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualServiceProviderConfig> {
        software.amazon.awscdk.services.appmesh.IMesh mesh;
        software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty virtualNodeProvider;
        software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty virtualRouterProvider;

        /**
         * Sets the value of {@link VirtualServiceProviderConfig#getMesh}
         * @param mesh Mesh the Provider is using. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        /**
         * Sets the value of {@link VirtualServiceProviderConfig#getVirtualNodeProvider}
         * @param virtualNodeProvider Virtual Node based provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeProvider(software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty virtualNodeProvider) {
            this.virtualNodeProvider = virtualNodeProvider;
            return this;
        }

        /**
         * Sets the value of {@link VirtualServiceProviderConfig#getVirtualRouterProvider}
         * @param virtualRouterProvider Virtual Router based provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterProvider(software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty virtualRouterProvider) {
            this.virtualRouterProvider = virtualRouterProvider;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualServiceProviderConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualServiceProviderConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualServiceProviderConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualServiceProviderConfig {
        private final software.amazon.awscdk.services.appmesh.IMesh mesh;
        private final software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty virtualNodeProvider;
        private final software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty virtualRouterProvider;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mesh = software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
            this.virtualNodeProvider = software.amazon.jsii.Kernel.get(this, "virtualNodeProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty.class));
            this.virtualRouterProvider = software.amazon.jsii.Kernel.get(this, "virtualRouterProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mesh = java.util.Objects.requireNonNull(builder.mesh, "mesh is required");
            this.virtualNodeProvider = builder.virtualNodeProvider;
            this.virtualRouterProvider = builder.virtualRouterProvider;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IMesh getMesh() {
            return this.mesh;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty getVirtualNodeProvider() {
            return this.virtualNodeProvider;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty getVirtualRouterProvider() {
            return this.virtualRouterProvider;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mesh", om.valueToTree(this.getMesh()));
            if (this.getVirtualNodeProvider() != null) {
                data.set("virtualNodeProvider", om.valueToTree(this.getVirtualNodeProvider()));
            }
            if (this.getVirtualRouterProvider() != null) {
                data.set("virtualRouterProvider", om.valueToTree(this.getVirtualRouterProvider()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualServiceProviderConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualServiceProviderConfig.Jsii$Proxy that = (VirtualServiceProviderConfig.Jsii$Proxy) o;

            if (!mesh.equals(that.mesh)) return false;
            if (this.virtualNodeProvider != null ? !this.virtualNodeProvider.equals(that.virtualNodeProvider) : that.virtualNodeProvider != null) return false;
            return this.virtualRouterProvider != null ? this.virtualRouterProvider.equals(that.virtualRouterProvider) : that.virtualRouterProvider == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mesh.hashCode();
            result = 31 * result + (this.virtualNodeProvider != null ? this.virtualNodeProvider.hashCode() : 0);
            result = 31 * result + (this.virtualRouterProvider != null ? this.virtualRouterProvider.hashCode() : 0);
            return result;
        }
    }
}
