package software.amazon.awscdk.services.appsync;

/**
 * Attributes for GraphQL imports.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi sourceApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * IGraphqlApi importedMergedApi = GraphqlApi.fromGraphqlApiAttributes(this, "ImportedMergedApi", GraphqlApiAttributes.builder()
 *         .graphqlApiId("MyApiId")
 *         .graphqlApiArn("MyApiArn")
 *         .build());
 * IRole importedExecutionRole = Role.fromRoleArn(this, "ExecutionRole", "arn:aws:iam::ACCOUNT:role/MyExistingRole");
 * SourceApiAssociation.Builder.create(this, "SourceApiAssociation2")
 *         .sourceApi(sourceApi)
 *         .mergedApi(importedMergedApi)
 *         .mergeType(MergeType.MANUAL_MERGE)
 *         .mergedApiExecutionRole(importedExecutionRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.435Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.GraphqlApiAttributes")
@software.amazon.jsii.Jsii.Proxy(GraphqlApiAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GraphqlApiAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGraphqlApiId();

    /**
     * the arn for the GraphQL Api.
     * <p>
     * Default: - autogenerated arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGraphqlApiArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GraphqlApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GraphqlApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GraphqlApiAttributes> {
        java.lang.String graphqlApiId;
        java.lang.String graphqlApiArn;

        /**
         * Sets the value of {@link GraphqlApiAttributes#getGraphqlApiId}
         * @param graphqlApiId an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder graphqlApiId(java.lang.String graphqlApiId) {
            this.graphqlApiId = graphqlApiId;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiAttributes#getGraphqlApiArn}
         * @param graphqlApiArn the arn for the GraphQL Api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder graphqlApiArn(java.lang.String graphqlApiArn) {
            this.graphqlApiArn = graphqlApiArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GraphqlApiAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GraphqlApiAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GraphqlApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GraphqlApiAttributes {
        private final java.lang.String graphqlApiId;
        private final java.lang.String graphqlApiArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.graphqlApiId = software.amazon.jsii.Kernel.get(this, "graphqlApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.graphqlApiArn = software.amazon.jsii.Kernel.get(this, "graphqlApiArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.graphqlApiId = java.util.Objects.requireNonNull(builder.graphqlApiId, "graphqlApiId is required");
            this.graphqlApiArn = builder.graphqlApiArn;
        }

        @Override
        public final java.lang.String getGraphqlApiId() {
            return this.graphqlApiId;
        }

        @Override
        public final java.lang.String getGraphqlApiArn() {
            return this.graphqlApiArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("graphqlApiId", om.valueToTree(this.getGraphqlApiId()));
            if (this.getGraphqlApiArn() != null) {
                data.set("graphqlApiArn", om.valueToTree(this.getGraphqlApiArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.GraphqlApiAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GraphqlApiAttributes.Jsii$Proxy that = (GraphqlApiAttributes.Jsii$Proxy) o;

            if (!graphqlApiId.equals(that.graphqlApiId)) return false;
            return this.graphqlApiArn != null ? this.graphqlApiArn.equals(that.graphqlApiArn) : that.graphqlApiArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.graphqlApiId.hashCode();
            result = 31 * result + (this.graphqlApiArn != null ? this.graphqlApiArn.hashCode() : 0);
            return result;
        }
    }
}
