package software.amazon.awscdk.services.batch;

/**
 * Represents a Fairshare Scheduling Policy. Instructs the scheduler to allocate ComputeEnvironment vCPUs based on Job shareIdentifiers.
 * <p>
 * The Faireshare Scheduling Policy ensures that each share gets a certain amount of vCPUs.
 * It does this by deciding how many Jobs of each share to schedule <em>relative to how many jobs of
 * each share are currently being executed by the ComputeEnvironment</em>. The weight factors associated with
 * each share determine the ratio of vCPUs allocated; see the readme for a more in-depth discussion of
 * fairshare policies.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.911Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IFairshareSchedulingPolicy")
@software.amazon.jsii.Jsii.Proxy(IFairshareSchedulingPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IFairshareSchedulingPolicy extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.ISchedulingPolicy {

    /**
     * The shares that this Scheduling Policy applies to.
     * <p>
     * <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
     * are not recognized by the Scheduling Policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Share> getShares();

    /**
     * Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
     * <p>
     * The percentage reserved is defined by the Scheduler as:
     * <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
     * <p>
     * For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
     * maximum available vCPU if there's only one fair share identifier.
     * It reserves 25% if there are two fair share identifiers.
     * It reserves 12.5% if there are three fair share identifiers.
     * <p>
     * A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
     * maximum available vCPU if there's only one fair share identifier,
     * 6.25% if there are two fair share identifiers,
     * and 1.56% if there are three fair share identifiers.
     * <p>
     * Default: - no vCPU is reserved
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
        return null;
    }

    /**
     * The amount of time to use to measure the usage of each job.
     * <p>
     * The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
     * A value of zero (0) indicates that only current usage is measured.
     * The decay is linear and gives preference to newer jobs.
     * <p>
     * The maximum supported value is 604800 seconds (1 week).
     * <p>
     * Default: - 0: only the current job usage is considered
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getShareDecay() {
        return null;
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IFairshareSchedulingPolicy.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The arn of this scheduling policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getSchedulingPolicyArn() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of this scheduling policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getSchedulingPolicyName() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The shares that this Scheduling Policy applies to.
         * <p>
         * <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
         * are not recognized by the Scheduling Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Share> getShares() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "shares", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Share.class))));
        }

        /**
         * Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
         * <p>
         * The percentage reserved is defined by the Scheduler as:
         * <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
         * <p>
         * For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
         * maximum available vCPU if there's only one fair share identifier.
         * It reserves 25% if there are two fair share identifiers.
         * It reserves 12.5% if there are three fair share identifiers.
         * <p>
         * A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
         * maximum available vCPU if there's only one fair share identifier,
         * 6.25% if there are two fair share identifiers,
         * and 1.56% if there are three fair share identifiers.
         * <p>
         * Default: - no vCPU is reserved
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
            return software.amazon.jsii.Kernel.get(this, "computeReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The amount of time to use to measure the usage of each job.
         * <p>
         * The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
         * A value of zero (0) indicates that only current usage is measured.
         * The decay is linear and gives preference to newer jobs.
         * <p>
         * The maximum supported value is 604800 seconds (1 week).
         * <p>
         * Default: - 0: only the current job usage is considered
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getShareDecay() {
            return software.amazon.jsii.Kernel.get(this, "shareDecay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }
    }

    /**
     * Internal default implementation for {@link IFairshareSchedulingPolicy}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IFairshareSchedulingPolicy, software.amazon.awscdk.services.batch.ISchedulingPolicy.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The arn of this scheduling policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getSchedulingPolicyArn() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of this scheduling policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getSchedulingPolicyName() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The shares that this Scheduling Policy applies to.
         * <p>
         * <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
         * are not recognized by the Scheduling Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Share> getShares() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "shares", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Share.class))));
        }

        /**
         * Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
         * <p>
         * The percentage reserved is defined by the Scheduler as:
         * <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
         * <p>
         * For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
         * maximum available vCPU if there's only one fair share identifier.
         * It reserves 25% if there are two fair share identifiers.
         * It reserves 12.5% if there are three fair share identifiers.
         * <p>
         * A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
         * maximum available vCPU if there's only one fair share identifier,
         * 6.25% if there are two fair share identifiers,
         * and 1.56% if there are three fair share identifiers.
         * <p>
         * Default: - no vCPU is reserved
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
            return software.amazon.jsii.Kernel.get(this, "computeReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The amount of time to use to measure the usage of each job.
         * <p>
         * The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
         * A value of zero (0) indicates that only current usage is measured.
         * The decay is linear and gives preference to newer jobs.
         * <p>
         * The maximum supported value is 604800 seconds (1 week).
         * <p>
         * Default: - 0: only the current job usage is considered
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getShareDecay() {
            return software.amazon.jsii.Kernel.get(this, "shareDecay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }
    }
}
