/**
 * <h1>Amazon Bedrock Construct Library</h1>
 * <p>
 * Amazon Bedrock is a fully managed service that offers a choice of foundation models (FMs)
 * along with a broad set of capabilities for building generative AI applications.
 * <p>
 * CloudFormation does not currently support any Bedrock resource types.
 * This construct library is a collection of constructs that can look up existing Bedrock models
 * for use with other services' CDK constructs, such as AWS Step Functions.
 * <p>
 * To look up a Bedrock base foundation model:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * 
 * 
 * FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.ANTHROPIC_CLAUDE_V2);
 * </pre></blockquote>
 * <p>
 * To look up a Bedrock provisioned throughput model:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * 
 * 
 * ProvisionedModel.fromProvisionedModelArn(this, "Model", "arn:aws:bedrock:us-east-2:123456789012:provisioned-model/abc-123");
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.bedrock;
