/**
 * <h1>AWS::Chatbot Construct Library</h1>
 * <p>
 * AWS Chatbot is an AWS service that enables DevOps and software development teams to use Slack chat rooms to monitor and respond to operational events in their AWS Cloud. AWS Chatbot processes AWS service notifications from Amazon Simple Notification Service (Amazon SNS), and forwards them to Slack chat rooms so teams can analyze and act on them immediately, regardless of location.
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.chatbot.*;
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.iam.*;
 * 
 * 
 * SlackChannelConfiguration slackChannel = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * 
 * slackChannel.addToRolePolicy(PolicyStatement.Builder.create()
 *         .effect(Effect.ALLOW)
 *         .actions(List.of("s3:GetObject"))
 *         .resources(List.of("arn:aws:s3:::abc/xyz/123.txt"))
 *         .build());
 * 
 * slackChannel.addNotificationTopic(new Topic(this, "MyTopic"));
 * </pre></blockquote>
 * <p>
 * <h2>Log Group</h2>
 * <p>
 * Slack channel configuration automatically create a log group with the name <code>/aws/chatbot/&lt;configuration-name&gt;</code> in <code>us-east-1</code> upon first execution with
 * log data set to never expire.
 * <p>
 * The <code>logRetention</code> property can be used to set a different expiration period. A log group will be created if not already exists.
 * If the log group already exists, it's expiration will be configured to the value specified in this construct (never expire, by default).
 * <p>
 * By default, CDK uses the AWS SDK retry options when interacting with the log group. The <code>logRetentionRetryOptions</code> property
 * allows you to customize the maximum number of retries and base backoff duration.
 * <p>
 * <em>Note</em> that, if <code>logRetention</code> is set, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html">CloudFormation custom
 * resource</a> is added
 * to the stack that pre-creates the log group as part of the stack deployment, if it already doesn't exist, and sets the
 * correct log retention period (never expire, by default).
 * <p>
 * <h2>Guardrails</h2>
 * <p>
 * By default slack channel will use <code>AdministratorAccess</code> managed policy as guardrail policy.
 * The <code>guardrailPolicies</code> property can be used to set a different set of managed policies.
 */
package software.amazon.awscdk.services.chatbot;
