package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnHookTypeConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnHookTypeConfigProps cfnHookTypeConfigProps = CfnHookTypeConfigProps.builder()
 *         .configuration("configuration")
 *         // the properties below are optional
 *         .configurationAlias("configurationAlias")
 *         .typeArn("typeArn")
 *         .typeName("typeName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.101Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnHookTypeConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnHookTypeConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHookTypeConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the activated hook type configuration, in this AWS account and AWS Region .
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfiguration();

    /**
     * Specifies the activated hook type configuration, in this AWS account and AWS Region .
     * <p>
     * Defaults to <code>default</code> alias. Hook types currently support default configuration alias.
     * <p>
     * Default: - "default"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-configurationalias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-configurationalias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationAlias() {
        return null;
    }

    /**
     * The Amazon Resource Number (ARN) for the hook to set <code>Configuration</code> for.
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-typearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-typearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTypeArn() {
        return null;
    }

    /**
     * The unique name for your hook.
     * <p>
     * Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-hooktypeconfig.html#cfn-cloudformation-hooktypeconfig-typename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHookTypeConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHookTypeConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHookTypeConfigProps> {
        java.lang.String configuration;
        java.lang.String configurationAlias;
        java.lang.String typeArn;
        java.lang.String typeName;

        /**
         * Sets the value of {@link CfnHookTypeConfigProps#getConfiguration}
         * @param configuration Specifies the activated hook type configuration, in this AWS account and AWS Region . This parameter is required.
         *                      You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(java.lang.String configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookTypeConfigProps#getConfigurationAlias}
         * @param configurationAlias Specifies the activated hook type configuration, in this AWS account and AWS Region .
         *                           Defaults to <code>default</code> alias. Hook types currently support default configuration alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAlias(java.lang.String configurationAlias) {
            this.configurationAlias = configurationAlias;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookTypeConfigProps#getTypeArn}
         * @param typeArn The Amazon Resource Number (ARN) for the hook to set <code>Configuration</code> for.
         *                You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeArn(java.lang.String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookTypeConfigProps#getTypeName}
         * @param typeName The unique name for your hook.
         *                 Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
         *                 <p>
         *                 You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHookTypeConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHookTypeConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHookTypeConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHookTypeConfigProps {
        private final java.lang.String configuration;
        private final java.lang.String configurationAlias;
        private final java.lang.String typeArn;
        private final java.lang.String typeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationAlias = software.amazon.jsii.Kernel.get(this, "configurationAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeArn = software.amazon.jsii.Kernel.get(this, "typeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.configurationAlias = builder.configurationAlias;
            this.typeArn = builder.typeArn;
            this.typeName = builder.typeName;
        }

        @Override
        public final java.lang.String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getConfigurationAlias() {
            return this.configurationAlias;
        }

        @Override
        public final java.lang.String getTypeArn() {
            return this.typeArn;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));
            if (this.getConfigurationAlias() != null) {
                data.set("configurationAlias", om.valueToTree(this.getConfigurationAlias()));
            }
            if (this.getTypeArn() != null) {
                data.set("typeArn", om.valueToTree(this.getTypeArn()));
            }
            if (this.getTypeName() != null) {
                data.set("typeName", om.valueToTree(this.getTypeName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnHookTypeConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHookTypeConfigProps.Jsii$Proxy that = (CfnHookTypeConfigProps.Jsii$Proxy) o;

            if (!configuration.equals(that.configuration)) return false;
            if (this.configurationAlias != null ? !this.configurationAlias.equals(that.configurationAlias) : that.configurationAlias != null) return false;
            if (this.typeArn != null ? !this.typeArn.equals(that.typeArn) : that.typeArn != null) return false;
            return this.typeName != null ? this.typeName.equals(that.typeName) : that.typeName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            result = 31 * result + (this.configurationAlias != null ? this.configurationAlias.hashCode() : 0);
            result = 31 * result + (this.typeArn != null ? this.typeArn.hashCode() : 0);
            result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            return result;
        }
    }
}
