package software.amazon.awscdk.services.codebuild;

/**
 * Properties for defining a <code>CfnFleet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * CfnFleetProps cfnFleetProps = CfnFleetProps.builder()
 *         .baseCapacity(123)
 *         .computeType("computeType")
 *         .environmentType("environmentType")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CfnFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-basecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-basecapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
        return null;
    }

    /**
     * Information about the compute resources the compute fleet uses. Available values include:.
     * <p>
     * <ul>
     * <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 3 GB memory and 2 vCPUs for builds.</li>
     * <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 7 GB memory and 4 vCPUs for builds.</li>
     * <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.</li>
     * <li><code>BUILD_GENERAL1_XLARGE</code> : Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.</li>
     * <li><code>BUILD_GENERAL1_2XLARGE</code> : Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.</li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_SMALL</code> :
     * <p>
     * <ul>
     * <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 3 GB memory and 2 vCPUs for builds.</li>
     * <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.</li>
     * <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.</li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_LARGE</code> :
     * <p>
     * <ul>
     * <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 15 GB memory and 8 vCPUs for builds.</li>
     * <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</li>
     * <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-computetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeType() {
        return null;
    }

    /**
     * The environment type of the compute fleet.
     * <p>
     * <ul>
     * <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).</li>
     * <li>The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
     * <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).</li>
     * <li>The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).</li>
     * <li>The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-environmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-environmenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentType() {
        return null;
    }

    /**
     * The name of the compute fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A list of tag key and value pairs associated with this compute fleet.
     * <p>
     * These tags are available for use by AWS services that support AWS CodeBuild compute fleet tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-fleet.html#cfn-codebuild-fleet-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFleetProps> {
        java.lang.Number baseCapacity;
        java.lang.String computeType;
        java.lang.String environmentType;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFleetProps#getBaseCapacity}
         * @param baseCapacity The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(java.lang.Number baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getComputeType}
         * @param computeType Information about the compute resources the compute fleet uses. Available values include:.
         *                    <ul>
         *                    <li><code>BUILD_GENERAL1_SMALL</code> : Use up to 3 GB memory and 2 vCPUs for builds.</li>
         *                    <li><code>BUILD_GENERAL1_MEDIUM</code> : Use up to 7 GB memory and 4 vCPUs for builds.</li>
         *                    <li><code>BUILD_GENERAL1_LARGE</code> : Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.</li>
         *                    <li><code>BUILD_GENERAL1_XLARGE</code> : Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.</li>
         *                    <li><code>BUILD_GENERAL1_2XLARGE</code> : Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.</li>
         *                    </ul>
         *                    <p>
         *                    If you use <code>BUILD_GENERAL1_SMALL</code> :
         *                    <p>
         *                    <ul>
         *                    <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 3 GB memory and 2 vCPUs for builds.</li>
         *                    <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.</li>
         *                    <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.</li>
         *                    </ul>
         *                    <p>
         *                    If you use <code>BUILD_GENERAL1_LARGE</code> :
         *                    <p>
         *                    <ul>
         *                    <li>For environment type <code>LINUX_CONTAINER</code> , you can use up to 15 GB memory and 8 vCPUs for builds.</li>
         *                    <li>For environment type <code>LINUX_GPU_CONTAINER</code> , you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</li>
         *                    <li>For environment type <code>ARM_CONTAINER</code> , you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.</li>
         *                    </ul>
         *                    <p>
         *                    For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(java.lang.String computeType) {
            this.computeType = computeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEnvironmentType}
         * @param environmentType The environment type of the compute fleet.
         *                        <ul>
         *                        <li>The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).</li>
         *                        <li>The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).</li>
         *                        <li>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).</li>
         *                        <li>The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).</li>
         *                        <li>The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).</li>
         *                        </ul>
         *                        <p>
         *                        For more information, see <a href="https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <em>AWS CodeBuild user guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentType(java.lang.String environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getName}
         * @param name The name of the compute fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getTags}
         * @param tags A list of tag key and value pairs associated with this compute fleet.
         *             These tags are available for use by AWS services that support AWS CodeBuild compute fleet tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFleetProps {
        private final java.lang.Number baseCapacity;
        private final java.lang.String computeType;
        private final java.lang.String environmentType;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseCapacity = software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentType = software.amazon.jsii.Kernel.get(this, "environmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseCapacity = builder.baseCapacity;
            this.computeType = builder.computeType;
            this.environmentType = builder.environmentType;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getBaseCapacity() {
            return this.baseCapacity;
        }

        @Override
        public final java.lang.String getComputeType() {
            return this.computeType;
        }

        @Override
        public final java.lang.String getEnvironmentType() {
            return this.environmentType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBaseCapacity() != null) {
                data.set("baseCapacity", om.valueToTree(this.getBaseCapacity()));
            }
            if (this.getComputeType() != null) {
                data.set("computeType", om.valueToTree(this.getComputeType()));
            }
            if (this.getEnvironmentType() != null) {
                data.set("environmentType", om.valueToTree(this.getEnvironmentType()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CfnFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFleetProps.Jsii$Proxy that = (CfnFleetProps.Jsii$Proxy) o;

            if (this.baseCapacity != null ? !this.baseCapacity.equals(that.baseCapacity) : that.baseCapacity != null) return false;
            if (this.computeType != null ? !this.computeType.equals(that.computeType) : that.computeType != null) return false;
            if (this.environmentType != null ? !this.environmentType.equals(that.environmentType) : that.environmentType != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baseCapacity != null ? this.baseCapacity.hashCode() : 0;
            result = 31 * result + (this.computeType != null ? this.computeType.hashCode() : 0);
            result = 31 * result + (this.environmentType != null ? this.environmentType.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
